/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.util.PrettyPrinter;

abstract class InventoryBasedTransaction
extends GameTransaction<ChangeInventoryEvent> {
    final Inventory inventory;
    @MonotonicNonNull List<class_1297> entities;
    private @MonotonicNonNull List<SlotTransaction> acceptedTransactions;
    protected boolean used = false;

    protected InventoryBasedTransaction(Inventory inventory) {
        super((TransactionType)TransactionTypes.CHANGE_INVENTORY_EVENT.get());
        this.inventory = inventory;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> frame.pushCause((Object)this.inventory));
    }

    @Override
    public Optional<ChangeInventoryEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<ChangeInventoryEvent>> gameTransactions, Cause currentCause) {
        ImmutableList containerBasedTransactions = (ImmutableList)gameTransactions.stream().filter(tx -> tx instanceof InventoryBasedTransaction).map(tx -> (InventoryBasedTransaction)tx).filter(tx -> !tx.used).collect(ImmutableList.toImmutableList());
        List slotTransactions = containerBasedTransactions.stream().map(InventoryBasedTransaction::getSlotTransactions).flatMap(Collection::stream).collect(Collectors.toList());
        for (InventoryBasedTransaction transaction : containerBasedTransactions) {
            transaction.used = true;
        }
        List entities = containerBasedTransactions.stream().map(InventoryBasedTransaction::getEntitiesSpawned).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Slot, List<SlotTransaction>> collected = slotTransactions.stream().collect(Collectors.groupingBy(SlotTransaction::slot));
        slotTransactions.clear();
        collected.values().forEach(list -> {
            SlotTransaction first = (SlotTransaction)list.get(0);
            if (list.size() > 1) {
                ItemStackSnapshot last = (ItemStackSnapshot)((SlotTransaction)list.get(list.size() - 1)).defaultReplacement();
                slotTransactions.add(new SlotTransaction(first.slot(), (ItemStackSnapshot)first.original(), last));
            } else {
                slotTransactions.add(first);
            }
        });
        return containerBasedTransactions.stream().map(t -> t.createInventoryEvent(slotTransactions, entities, context, currentCause)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    List<SlotTransaction> getSlotTransactions() {
        return this.acceptedTransactions == null ? Collections.emptyList() : this.acceptedTransactions;
    }

    Optional<ChangeInventoryEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause currentCause) {
        return Optional.empty();
    }

    List<Entity> getEntitiesSpawned() {
        return this.entities == null ? Collections.emptyList() : this.entities;
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
    }

    protected void handleEventResults(class_1657 player, ChangeInventoryEvent event) {
        PacketPhaseUtil.handleSlotRestore(player, null, event.transactions(), event.isCancelled());
        if (this.entities != null && event instanceof SpawnEntityEvent) {
            EntityUtil.despawnFilteredEntities(this.entities, (SpawnEntityEvent)event);
        }
    }

    @Override
    public boolean markCancelledTransactions(ChangeInventoryEvent event, ImmutableList<? extends GameTransaction<ChangeInventoryEvent>> gameTransactions) {
        if (event.isCancelled()) {
            event.transactions().forEach(Transaction::invalidate);
            return true;
        }
        boolean cancelledAny = false;
        for (SlotTransaction transaction : event.transactions()) {
            if (transaction.isValid()) continue;
            cancelledAny = true;
            for (GameTransaction gameTransaction : gameTransactions) {
                ((InventoryBasedTransaction)gameTransaction).getSlotTransactions().forEach(tx -> {
                    if (tx == transaction) {
                        gameTransaction.markCancelled();
                    }
                });
            }
        }
        return cancelledAny;
    }

    @Override
    public boolean absorbSlotTransaction(ContainerSlotTransaction slotTransaction) {
        if (this.inventory == slotTransaction.menu) {
            if (this.acceptedTransactions == null) {
                this.acceptedTransactions = new ArrayList<SlotTransaction>();
            }
            this.acceptedTransactions.add(slotTransaction.transaction);
            return true;
        }
        SlotTransaction newTransaction = slotTransaction.transaction;
        if (newTransaction.slot().viewedSlot() != newTransaction.slot() && this.inventory == newTransaction.slot().viewedSlot().parent()) {
            if (this.acceptedTransactions == null) {
                this.acceptedTransactions = new ArrayList<SlotTransaction>();
            }
            this.acceptedTransactions.add(new SlotTransaction(newTransaction.slot().viewedSlot(), (ItemStackSnapshot)newTransaction.original(), (ItemStackSnapshot)newTransaction.defaultReplacement()));
            return true;
        }
        return false;
    }

    @Override
    public boolean absorbSpawnEntity(PhaseContext<@NonNull ?> context, SpawnEntityTransaction spawn) {
        if (context.doesContainerCaptureEntitySpawn(spawn.entityToSpawn)) {
            if (this.entities == null) {
                this.entities = new LinkedList<class_1297>();
            }
            this.entities.add(spawn.entityToSpawn);
            return true;
        }
        return super.absorbSpawnEntity(context, spawn);
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    protected boolean shouldBuildEventAndRestartBatch(GameTransaction<@NonNull ?> pointer, PhaseContext<@NonNull ?> context) {
        return super.shouldBuildEventAndRestartBatch(pointer, context) || ((InventoryBasedTransaction)pointer).inventory != this.inventory;
    }
}

