/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2735;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.inventory.InventoryBasedTransaction;

public class SetCarriedItemTransaction
extends InventoryBasedTransaction {
    private final class_3222 player;
    private final @Nullable Slot prevSlot;
    private final @Nullable Slot newSlot;
    private final int prevSlotId;

    public SetCarriedItemTransaction(class_1657 player, int newSlot) {
        super((Inventory)player.method_31548());
        this.player = (class_3222)player;
        PlayerInventory inventory = (PlayerInventory)this.player.method_31548();
        this.prevSlotId = this.player.method_31548().field_7545;
        this.prevSlot = inventory.hotbar().slot(this.prevSlotId).orElse(null);
        this.newSlot = inventory.hotbar().slot(newSlot).orElse(null);
    }

    @Override
    Optional<ChangeInventoryEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        if (!entities.isEmpty()) {
            SpongeCommon.logger().warn("Entities are being captured but not being processed");
        }
        if (this.newSlot == null || this.prevSlot == null) {
            return Optional.empty();
        }
        ChangeInventoryEvent.Held event = SpongeEventFactory.createChangeInventoryEventHeld((Cause)cause, (Slot)this.newSlot, (Inventory)((Inventory)this.player.method_31548()), (Slot)this.prevSlot, slotTransactions);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        this.player.field_13987.method_14364((class_2596)new class_2735(this.prevSlotId));
        this.player.method_31548().field_7545 = this.prevSlotId;
        this.handleEventResults((class_1657)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        this.handleEventResults((class_1657)this.player, event);
    }
}

