/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ChunkPipeline
implements BlockPipeline {
    private final @Nullable Supplier<class_2818> chunkSupplier;
    private final @Nullable Supplier<class_3218> serverWorld;
    private final @Nullable Supplier<class_2826> sectionSupplier;
    private final boolean wasEmpty;
    private final List<ResultingTransactionBySideEffect> chunkEffects;
    final ChangeBlock transaction;

    public static ChunkPipeline nullReturn(class_2818 chunk, class_3218 world) {
        return new ChunkPipeline(chunk, world);
    }

    private ChunkPipeline(class_2818 chunk, class_3218 world) {
        WeakReference<class_2818> chunkWeakReference = new WeakReference<class_2818>(chunk);
        this.chunkSupplier = () -> (class_2818)chunkWeakReference.get();
        WeakReference<class_3218> serverWorldWeakReference = new WeakReference<class_3218>(world);
        this.serverWorld = () -> (class_3218)serverWorldWeakReference.get();
        this.sectionSupplier = () -> null;
        this.wasEmpty = true;
        this.chunkEffects = Collections.emptyList();
        this.transaction = null;
    }

    ChunkPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.chunkEffects = builder.effects;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        this.wasEmpty = Objects.requireNonNull(builder.sectionSupplier).get().method_38292();
        this.transaction = builder.transaction;
    }

    public Supplier<class_2818> getChunkSupplier() {
        return this.chunkSupplier;
    }

    public List<ResultingTransactionBySideEffect> getChunkEffects() {
        return this.chunkEffects;
    }

    @Override
    public class_3218 getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in ChunkPipeline").get();
    }

    @Override
    public class_2818 getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in ChunkPipeline").get();
    }

    @Override
    public class_2826 getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in ChunkPipeline").get();
    }

    public @Nullable class_2680 processChange(PhaseContext<?> context, class_2680 currentState, class_2680 proposedState, class_2338 pos, int limit) {
        if (this.chunkEffects.isEmpty()) {
            return null;
        }
        class_3218 serverWorld = this.serverWorld.get();
        int oldOpacity = currentState.method_26193();
        SpongeBlockChangeFlag flag = this.transaction.getBlockChangeFlag();
        @Nullable class_2586 existing = this.chunkSupplier.get().method_12201(pos, class_2818.class_2819.field_12859);
        PipelineCursor formerState = new PipelineCursor(currentState, pos, existing, null, limit);
        for (ResultingTransactionBySideEffect effect : this.chunkEffects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            try {
                EffectResult result = effect.effect.processSideEffect(this, formerState, proposedState, flag, limit);
                if (result.hasResult) {
                    class_2680 class_26802 = result.resultingState;
                    return class_26802;
                }
                if (!formerState.drops().isEmpty() || result.drops.isEmpty()) continue;
                formerState = new PipelineCursor(currentState, pos, existing, null, result.drops, limit);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    public static final class Builder {
        @Nullable Supplier<class_3218> serverWorld;
        @Nullable Supplier<class_2818> chunkSupplier;
        @Nullable Supplier<class_2826> sectionSupplier;
        boolean wasSectionEmpty;
        @MonotonicNonNull ChangeBlock transaction;
        List<ResultingTransactionBySideEffect> effects;

        public Builder kickOff(ChangeBlock transaction) {
            this.transaction = Objects.requireNonNull(transaction, "ChangeBlock transaction cannot be null!");
            return this;
        }

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public Builder chunk(class_2818 chunk) {
            WeakReference<class_2818> worldRef = new WeakReference<class_2818>(chunk);
            this.chunkSupplier = () -> {
                class_2818 chunkRef = (class_2818)worldRef.get();
                if (chunkRef == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return chunkRef;
            };
            return this;
        }

        public Builder chunkSection(class_2826 section) {
            WeakReference<class_2826> worldRef = new WeakReference<class_2826>(section);
            this.sectionSupplier = () -> {
                class_2826 chunkRef = (class_2826)worldRef.get();
                if (chunkRef == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return chunkRef;
            };
            this.wasSectionEmpty = section.method_38292();
            return this;
        }

        public Builder world(class_3218 world) {
            WeakReference<class_3218> worldRef = new WeakReference<class_3218>(world);
            this.serverWorld = () -> {
                class_3218 serverWorld = (class_3218)worldRef.get();
                if (serverWorld == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return serverWorld;
            };
            return this;
        }

        public ChunkPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            Objects.requireNonNull(this.transaction, "ChangeBlock transaction must have been recorded!");
            return new ChunkPipeline(this);
        }
    }
}

