/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class TileEntityPipeline
implements BlockPipeline {
    private final @Nullable Supplier<class_2818> chunkSupplier;
    private final @Nullable Supplier<class_3218> serverWorld;
    private final @Nullable Supplier<class_2826> sectionSupplier;
    private final List<ResultingTransactionBySideEffect> effects;

    private TileEntityPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        this.effects = builder.effects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder kickOff(class_3218 world, class_2338 pos) {
        WeakReference<class_3218> worldRef = new WeakReference<class_3218>(world);
        class_2818 chunk = world.method_8500(pos);
        WeakReference<class_2818> chunkRef = new WeakReference<class_2818>(chunk);
        WeakReference<class_2826> sectionRef = new WeakReference<class_2826>(chunk.method_38259(chunk.method_31602(pos.method_10264())));
        Supplier<class_3218> worldSupplier = () -> Objects.requireNonNull((class_3218)worldRef.get(), "ServerWorld de-referenced");
        Supplier<class_2818> chunkSupplier = () -> Objects.requireNonNull((class_2818)chunkRef.get(), "Chunk de-referenced");
        Supplier<class_2826> chunkSectionSupplier = () -> Objects.requireNonNull((class_2826)sectionRef.get(), "ChunkSection de-referenced");
        return TileEntityPipeline.builder().chunk(chunkSupplier).world(worldSupplier).chunkSection(chunkSectionSupplier);
    }

    @Override
    public class_3218 getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public class_2818 getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public class_2826 getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public boolean wasEmpty() {
        return false;
    }

    public boolean processEffects(PhaseContext<?> context, PipelineCursor initialCursor) {
        PipelineCursor currentCursor = initialCursor;
        for (ResultingTransactionBySideEffect effect : this.effects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            try {
                EffectResult result = effect.effect.processSideEffect(this, currentCursor, currentCursor.state(), (SpongeBlockChangeFlag)BlockChangeFlags.NONE, currentCursor.limit());
                if (result.resultingState != currentCursor.state()) {
                    currentCursor = new PipelineCursor(result.resultingState, currentCursor.pos(), currentCursor.tileEntity(), currentCursor.destroyer(), currentCursor.limit());
                }
                if (!result.hasResult) continue;
                boolean bl = result.resultingState != null;
                return bl;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return false;
    }

    public static final class Builder {
        @Nullable Supplier<class_3218> serverWorld;
        @Nullable Supplier<class_2818> chunkSupplier;
        @Nullable Supplier<class_2826> sectionSupplier;
        List<ResultingTransactionBySideEffect> effects;

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public Builder chunk(Supplier<class_2818> chunk) {
            this.chunkSupplier = chunk;
            return this;
        }

        public Builder chunkSection(Supplier<class_2826> section) {
            this.sectionSupplier = section;
            return this;
        }

        public Builder world(Supplier<class_3218> world) {
            this.serverWorld = world;
            return this;
        }

        public TileEntityPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            Objects.requireNonNull(this.serverWorld, "ServerWorld must have been recorded!");
            Objects.requireNonNull(this.chunkSupplier, "Chunk must have been recorded!");
            return new TileEntityPipeline(this);
        }
    }
}

