/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class WorldPipeline
implements BlockPipeline {
    private final Supplier<class_2818> chunkSupplier;
    private final Supplier<class_3218> serverWorld;
    private final Supplier<class_2826> sectionSupplier;
    private final boolean wasEmpty;
    private final List<ResultingTransactionBySideEffect> worldEffects;
    private final ChunkPipeline chunkPipeline;

    WorldPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.worldEffects = builder.effects;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        @Nullable class_2826 chunkSection = Objects.requireNonNull(builder.sectionSupplier).get();
        this.wasEmpty = chunkSection == null || chunkSection.method_38292();
        this.chunkPipeline = builder.chunkPipeline;
    }

    @Override
    public class_3218 getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in ChunkPipeline").get();
    }

    @Override
    public class_2818 getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in ChunkPipeline").get();
    }

    @Override
    public class_2826 getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in ChunkPipeline").get();
    }

    public boolean processEffects(PhaseContext<?> context, class_2680 currentState, class_2680 newProposedState, class_2338 pos, @Nullable class_1297 destroyer, SpongeBlockChangeFlag flag, int limit) {
        if (this.worldEffects.isEmpty()) {
            return false;
        }
        class_3218 serverWorld = Objects.requireNonNull(this.serverWorld).get();
        @Nullable class_2586 existing = this.chunkSupplier.get().method_12201(pos, class_2818.class_2819.field_12859);
        @Nullable class_2680 oldState = this.chunkPipeline.processChange(context, currentState, newProposedState, pos, limit);
        if (oldState == null) {
            return false;
        }
        int oldOpacity = oldState.method_26193();
        PipelineCursor formerState = new PipelineCursor(oldState, pos, existing, destroyer, limit);
        for (ResultingTransactionBySideEffect effect : this.worldEffects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            try {
                EffectResult result = effect.effect.processSideEffect(this, formerState, newProposedState, flag, limit);
                if (result.hasResult) {
                    boolean bl = result.resultingState != null;
                    return bl;
                }
                if (!formerState.drops().isEmpty() || result.drops.isEmpty()) continue;
                formerState = new PipelineCursor(oldState, pos, existing, formerState.destroyer(), result.drops, limit);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return false;
    }

    public static Builder builder(ChunkPipeline pipeline) {
        return new Builder(Objects.requireNonNull(pipeline, "ChunkPipeline cannot be null!"));
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    public static final class Builder {
        final Supplier<class_3218> serverWorld = chunkPipeline::getServerWorld;
        final Supplier<class_2818> chunkSupplier = chunkPipeline::getAffectedChunk;
        final Supplier<class_2826> sectionSupplier = chunkPipeline::getAffectedSection;
        @MonotonicNonNull List<ResultingTransactionBySideEffect> effects;
        final ChunkPipeline chunkPipeline;

        Builder(ChunkPipeline chunkPipeline) {
            this.chunkPipeline = chunkPipeline;
        }

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public WorldPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            return new WorldPipeline(this);
        }
    }
}

