/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.type;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.BlockTransaction;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;

public final class BlockTransactionType
extends TransactionType<ChangeBlockEvent.All> {
    public BlockTransactionType() {
        super(true, "BLOCK");
    }

    @Override
    protected void consumeEventsAndMarker(PhaseContext<@NonNull ?> context, Collection<? extends ChangeBlockEvent.All> changeBlockEvents) {
        LinkedListMultimap eventsByWorld = LinkedListMultimap.create();
        changeBlockEvents.forEach(arg_0 -> BlockTransactionType.lambda$consumeEventsAndMarker$0((Multimap)eventsByWorld, arg_0));
        eventsByWorld.asMap().forEach((key, events) -> {
            Optional<ServerWorld> serverWorld = ((SpongeServer)SpongeCommon.server()).worldManager().world((ResourceKey)key);
            if (serverWorld.isEmpty()) {
                return;
            }
            ArrayList<BlockTransactionReceipt> transactions = new ArrayList<BlockTransactionReceipt>();
            for (ChangeBlockEvent.All event : events) {
                if (event.isCancelled()) continue;
                transactions.ensureCapacity(event.transactions().size());
                for (BlockTransaction transaction : event.transactions()) {
                    if (!transaction.isValid()) continue;
                    SpongeBlockSnapshot original = (SpongeBlockSnapshot)transaction.original();
                    SpongeBlockSnapshot result = (SpongeBlockSnapshot)transaction.finalReplacement();
                    Operation operation = context.getBlockOperation(original, result);
                    BlockTransactionReceipt eventTransaction = new BlockTransactionReceipt((BlockSnapshot)original, (BlockSnapshot)result, operation);
                    transactions.add(eventTransaction);
                    context.postBlockTransactionApplication(serverWorld.get(), original.blockChange, eventTransaction);
                }
            }
            if (transactions.isEmpty()) {
                return;
            }
            Cause cause = PhaseTracker.getInstance().currentCause();
            SpongeCommon.post((Event)SpongeEventFactory.createChangeBlockEventPost((Cause)cause, Collections.unmodifiableList(transactions), (ServerWorld)serverWorld.get()));
        });
    }

    private static /* synthetic */ void lambda$consumeEventsAndMarker$0(Multimap eventsByWorld, ChangeBlockEvent.All event) {
        eventsByWorld.put((Object)event.world().key(), (Object)event);
    }
}

