/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.world;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.entity.HarvestEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.damagesource.CombatTrackerAccessor;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

public final class EntityPerformingDropsTransaction
extends WorldBasedTransaction<HarvestEntityEvent> {
    private @MonotonicNonNull Supplier<class_3218> worldSupplier;
    final class_1297 destroyingEntity;
    private @MonotonicNonNull class_2487 entityTag;
    private @MonotonicNonNull Supplier<Optional<class_1282>> lastAttacker;

    public EntityPerformingDropsTransaction(class_1297 destroyingEntity) {
        super((TransactionType)TransactionTypes.ENTITY_DEATH_DROPS.get(), ((ServerWorld)destroyingEntity.method_37908()).key());
        this.destroyingEntity = destroyingEntity;
    }

    @Override
    protected void captureState() {
        class_1282 lastAttacker;
        super.captureState();
        class_1297 entity = this.destroyingEntity;
        this.worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier((class_3218)entity.method_37908(), "ServerLevel");
        class_2487 tag = new class_2487();
        entity.method_5647(tag);
        this.entityTag = tag;
        if (entity instanceof class_1309) {
            List<class_1281> entries = ((CombatTrackerAccessor)((class_1309)entity).method_6066()).accessor$entries();
            if (!entries.isEmpty()) {
                class_1281 entry = entries.get(entries.size() - 1);
                lastAttacker = entry.comp_1535();
            } else {
                lastAttacker = null;
            }
        } else {
            lastAttacker = null;
        }
        WeakReference<@Nullable Object> ref = new WeakReference<Object>(lastAttacker);
        this.lastAttacker = () -> {
            @Nullable class_1282 damageSource = (class_1282)ref.get();
            if (damageSource == null) {
                return Optional.empty();
            }
            return Optional.of(damageSource);
        };
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptEntityDrops(this.destroyingEntity));
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, stackFrame) -> {
            stackFrame.pushCause((Object)this.destroyingEntity);
            this.lastAttacker.get().ifPresent(attacker -> stackFrame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (Object)((DamageSource)attacker)));
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public boolean acceptEntityDrops(class_1297 entity) {
        return this.destroyingEntity == entity;
    }

    @Override
    public boolean isUnbatchable() {
        return true;
    }

    @Override
    public Optional<HarvestEntityEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<HarvestEntityEvent>> gameTransactions, Cause currentCause) {
        return Optional.of(SpongeEventFactory.createHarvestEntityEvent((Cause)currentCause, (Entity)((Entity)this.destroyingEntity)));
    }

    @Override
    public void restore(PhaseContext<?> context, HarvestEntityEvent event) {
    }

    @Override
    public boolean markCancelledTransactions(HarvestEntityEvent event, ImmutableList<? extends GameTransaction<HarvestEntityEvent>> gameTransactions) {
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", EntityPerformingDropsTransaction.class.getSimpleName() + "[", "]").add("destroyingEntity=" + String.valueOf(this.destroyingEntity)).add("lastAttacker=" + String.valueOf(this.lastAttacker)).add("worldKey=" + String.valueOf(this.worldKey)).add("cancelled=" + this.cancelled).toString();
    }
}

