/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.world;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.math.vector.Vector3d;

public final class SpawnEntityTransaction
extends WorldBasedTransaction<SpawnEntityEvent> {
    final Supplier<class_3218> worldSupplier;
    @MonotonicNonNull class_2487 entityTag;
    public final class_1297 entityToSpawn;
    final Vector3d originalPosition;
    final Supplier<SpawnType> deducedSpawnType;

    public SpawnEntityTransaction(Supplier<class_3218> worldSupplier, class_1297 entityToSpawn, Supplier<SpawnType> deducedSpawnType) {
        super((TransactionType)TransactionTypes.SPAWN_ENTITY.get(), ((ServerWorld)worldSupplier.get()).key());
        this.worldSupplier = worldSupplier;
        this.entityToSpawn = entityToSpawn;
        this.originalPosition = new Vector3d(entityToSpawn.method_23317(), entityToSpawn.method_23318(), entityToSpawn.method_23321());
        this.deducedSpawnType = deducedSpawnType;
    }

    @Override
    protected void captureState() {
        super.captureState();
        this.entityTag = this.entityToSpawn.method_5647(new class_2487());
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> {
            if (parent instanceof ChangeBlock) {
                frame.pushCause((Object)((ChangeBlock)parent).original);
                frame.addContext(EventContextKeys.BLOCK_TARGET, (Object)((ChangeBlock)parent).original);
            }
            frame.addContext(EventContextKeys.SPAWN_TYPE, this.deducedSpawnType);
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    protected boolean shouldBuildEventAndRestartBatch(GameTransaction<@NonNull ?> pointer, PhaseContext<@NonNull ?> context) {
        return super.shouldBuildEventAndRestartBatch(pointer, context) || this.deducedSpawnType != ((SpawnEntityTransaction)pointer).deducedSpawnType;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.absorbSpawnEntity(ctx, this));
    }

    @Override
    public Optional<SpawnEntityEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<SpawnEntityEvent>> gameTransactions, Cause currentCause) {
        ImmutableList collect = (ImmutableList)gameTransactions.stream().map(transaction -> (SpawnEntityTransaction)transaction).map(spawnRequest -> new Tuple((Object)spawnRequest.entityToSpawn, (Object)new DummySnapshot(spawnRequest.originalPosition, spawnRequest.entityTag, spawnRequest.worldSupplier))).collect(ImmutableList.toImmutableList());
        return Optional.of(context.createSpawnEvent(parent, (ImmutableList<Tuple<class_1297, DummySnapshot>>)collect, currentCause));
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, SpawnEntityEvent event) {
        this.entityToSpawn.method_5650(class_1297.class_5529.field_26999);
    }

    @Override
    public boolean markCancelledTransactions(SpawnEntityEvent event, ImmutableList<? extends GameTransaction<SpawnEntityEvent>> gameTransactions) {
        boolean cancelledAny = false;
        for (GameTransaction gameTransaction : gameTransactions) {
            if (event.entities().contains(((SpawnEntityTransaction)gameTransaction).entityToSpawn)) continue;
            gameTransaction.markCancelled();
            cancelledAny = true;
        }
        return cancelledAny;
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, SpawnEntityEvent event) {
        Stream.of(context.getNotifier(), context.getCreator(), context.getSource(ServerPlayer.class).map(Identifiable::uniqueId)).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(creator -> event.entities().forEach(entity -> ((CreatorTrackedBridge)entity).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, (UUID)creator)));
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpawnEntityTransaction.class.getSimpleName() + "[", "]").add("worldKey=" + String.valueOf(this.worldKey)).add("entityToSpawn=" + String.valueOf(this.entityToSpawn)).add("originalPosition=" + String.valueOf(this.originalPosition)).toString();
    }

    public static final class DummySnapshot {
        final Vector3d originalPosition;
        final class_2487 entityTag;
        final Supplier<class_3218> worldSupplier;

        public DummySnapshot(Vector3d originalPosition, class_2487 entityTag, Supplier<class_3218> worldSupplier) {
            this.originalPosition = originalPosition;
            this.entityTag = entityTag;
            this.worldSupplier = worldSupplier;
        }
    }
}

