/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.common.util.VecHelper;

public class GrowablePhaseContext
extends PhaseContext<GrowablePhaseContext> {
    protected PhaseContext<?> priorContext;
    ItemStackSnapshot usedItem;
    class_1937 world;
    class_2680 blockState;
    class_2338 pos;
    SpongeBlockSnapshot snapshot;

    protected GrowablePhaseContext(IPhaseState<GrowablePhaseContext> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    public GrowablePhaseContext provideItem(class_1799 stack) {
        this.usedItem = ItemStackUtil.snapshotOf(stack);
        return this;
    }

    public GrowablePhaseContext world(class_1937 worldIn) {
        this.world = worldIn;
        return this;
    }

    public GrowablePhaseContext block(class_2680 blockState) {
        this.blockState = blockState;
        return this;
    }

    public GrowablePhaseContext pos(class_2338 pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public GrowablePhaseContext buildAndSwitch() {
        Preconditions.checkState(this.pos != null, "BlockPos is null");
        Preconditions.checkState(this.blockState != null, "BlockState is null");
        if (this.usedItem == null) {
            this.usedItem = ItemStackSnapshot.empty();
        }
        Preconditions.checkState(this.world != null, "World is null");
        this.priorContext = this.createdTracker.getPhaseContext();
        Preconditions.checkState(this.priorContext != null, "Prior context is null");
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled().world((class_3218)this.world).position(VecHelper.toVector3i(this.pos)).blockState(this.blockState).flag(BlockChangeFlags.NONE.withPhysics(true).withUpdateNeighbors(true).withNotifyObservers(true));
        this.priorContext.applyOwnerIfAvailable(builder::creator);
        this.priorContext.applyNotifierIfAvailable(builder::notifier);
        this.snapshot = builder.build();
        return (GrowablePhaseContext)super.buildAndSwitch();
    }

    @Override
    protected void reset() {
        super.reset();
        this.priorContext = null;
        this.usedItem = null;
        this.world = null;
        this.blockState = null;
        this.pos = null;
        this.snapshot = null;
    }

    @Override
    protected GrowablePhaseContext defensiveCopy(PhaseTracker tracker) {
        GrowablePhaseContext newCopy = (GrowablePhaseContext)super.defensiveCopy(tracker);
        return newCopy;
    }
}

