/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.class_1703;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhaseContext;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.util.PrettyPrinter;

public class CommandPhaseContext
extends GeneralPhaseContext<CommandPhaseContext> {
    @Nullable String command;
    @Nullable CommandMapping commandMapping;
    private @MonotonicNonNull Set<class_1703> modifiedContainers;
    private boolean closing;

    CommandPhaseContext(IPhaseState<CommandPhaseContext> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    @Override
    public boolean hasCaptures() {
        return super.hasCaptures();
    }

    @Override
    protected void reset() {
        super.reset();
        this.command = null;
        this.commandMapping = null;
        this.modifiedContainers = null;
        this.closing = false;
    }

    public CommandPhaseContext command(String command) {
        this.command = command;
        return this;
    }

    public CommandPhaseContext commandMapping(CommandMapping mapping) {
        this.commandMapping = mapping;
        return this;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent).add(s + "- %s: %s", "Command", this.command == null ? "empty command" : this.command).add(s + "- %s: %s", "Command Mapping", this.commandMapping == null ? "no mapping" : this.commandMapping.toString());
        return printer;
    }

    @Override
    public boolean captureModifiedContainer(class_1703 container) {
        if (this.closing) {
            return false;
        }
        if (this.modifiedContainers == null) {
            this.modifiedContainers = Sets.newHashSet();
        }
        this.modifiedContainers.add(container);
        return true;
    }

    @Override
    public void close() {
        this.closing = true;
        if (this.modifiedContainers != null) {
            InventoryUtil.postContainerEvents(this.modifiedContainers, this.getTransactor());
        }
        super.close();
    }
}

