/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.world.BlockChange;

final class CommandState
extends GeneralState<CommandPhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> COMMAND_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.commandMapping != null) {
            ctx.commandMapping.plugin().ifPresent(arg_0 -> ((CauseStackManager.StackFrame)frame).pushCause(arg_0));
            frame.pushCause((Object)ctx.commandMapping);
        }
    });

    CommandState() {
    }

    @Override
    public CommandPhaseContext createNewContext(PhaseTracker tracker) {
        return new CommandPhaseContext(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> getFrameModifier() {
        return this.COMMAND_MODIFIER;
    }

    @Override
    public void postBlockTransactionApplication(CommandPhaseContext context, ServerWorld serverWorld, BlockChange blockChange, BlockTransactionReceipt transaction) {
        PhaseTracker.getInstance().currentCause().first(Player.class).ifPresent(user -> TrackingUtil.associateTrackerToTarget(blockChange, transaction, user.uniqueId()));
    }

    @Override
    public void associateNeighborStateNotifier(CommandPhaseContext context, @Nullable class_2338 sourcePos, class_2248 block, class_2338 notifyPos, class_3218 minecraftWorld, PlayerTracker.Type notifier) {
        context.getSource(Player.class).ifPresent(player -> ((LevelChunkBridge)minecraftWorld.method_8500(notifyPos)).bridge$addTrackedBlockPosition(block, notifyPos, player.uniqueId(), PlayerTracker.Type.NOTIFIER));
    }

    @Override
    public void unwind(CommandPhaseContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(CommandPhaseContext context) {
        Optional<class_1657> playerSource = context.getSource(class_1657.class);
        if (playerSource.isPresent()) {
            return () -> (ResourceKey)((class_1657)playerSource.get()).method_37908().method_27983().method_29177();
        }
        return super.attemptWorldKey(context);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(CommandPhaseContext context, class_1297 entityToSpawn) {
        return SpawnTypes.PLACEMENT;
    }
}

