/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_9892;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.common.accessor.world.level.ServerExplosionAccessor;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhaseContext;
import org.spongepowered.common.util.PrettyPrinter;

public final class ExplosionContext
extends GeneralPhaseContext<ExplosionContext> {
    private class_9892 explosion;

    public ExplosionContext(PhaseTracker tracker) {
        super(GeneralPhase.State.EXPLOSION, tracker);
    }

    ExplosionContext populateFromCurrentState() {
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        context.appendContextPreExplosion(this);
        return this;
    }

    public ExplosionContext potentialExplosionSource(class_3218 worldServer, @Nullable class_1297 entityIn) {
        if (entityIn != null) {
            this.source(entityIn);
        } else {
            this.source(worldServer);
        }
        return this;
    }

    public ExplosionContext explosion(class_9892 explosion) {
        this.explosion = explosion;
        return this;
    }

    public class_9892 getExplosion() {
        return this.explosion;
    }

    public Explosion getSpongeExplosion() {
        return (Explosion)this.explosion;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s + "- %s: %s", "Explosion", this.explosion);
    }

    @Override
    protected void reset() {
        super.reset();
        this.explosion = null;
    }

    @Override
    protected boolean isRunaway(PhaseContext<?> phaseContext) {
        if (phaseContext.getClass() != ExplosionContext.class) {
            return false;
        }
        ServerExplosionAccessor otherExplosion = (ServerExplosionAccessor)((ExplosionContext)phaseContext).explosion;
        ServerExplosionAccessor thisExplosion = (ServerExplosionAccessor)this.explosion;
        return otherExplosion.accessor$level() == thisExplosion.accessor$level() && ((ExplosionContext)phaseContext).explosion.method_55109().equals((Object)this.explosion.method_55109());
    }
}

