/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_181;
import net.minecraft.class_1927;
import net.minecraft.class_8567;
import net.minecraft.class_9892;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.accessor.world.level.ServerExplosionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;

final class ExplosionState
extends GeneralState<ExplosionContext> {
    private final BiConsumer<CauseStackManager.StackFrame, ExplosionContext> EXPLOSION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        class_1297 exploder;
        class_9892 explosion = context.getExplosion();
        @Nullable class_1309 placedBy = explosion.method_8347();
        if (placedBy != null) {
            if (placedBy instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)placedBy).tracker$getCreatorUUID().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                ((CreatorTrackedBridge)placedBy).tracker$getNotifierUUID().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
            frame.addContext(EventContextKeys.IGNITER, (Object)((Living)placedBy));
        }
        if ((exploder = explosion.method_46406()) != null) {
            frame.pushCause((Object)exploder);
        }
        frame.pushCause((Object)explosion);
    });

    ExplosionState() {
    }

    @Override
    public ExplosionContext createNewContext(PhaseTracker tracker) {
        return new ExplosionContext(tracker).populateFromCurrentState();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, ExplosionContext> getFrameModifier() {
        return this.EXPLOSION_MODIFIER;
    }

    @Override
    public void populateLootContext(ExplosionContext phaseContext, class_8567.class_8568 lootBuilder) {
        class_9892 explosion = phaseContext.getExplosion();
        lootBuilder.method_51877(class_181.field_1226, (Object)explosion.method_46406());
        if (((ServerExplosionAccessor)explosion).accessor$blockInteraction() == class_1927.class_4179.field_18687) {
            lootBuilder.method_51874(class_181.field_1225, (Object)Float.valueOf(((ServerExplosionAccessor)explosion).accessor$radius()));
        }
    }

    @Override
    public void unwind(ExplosionContext context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public SpawnEntityEvent createSpawnEvent(ExplosionContext context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<class_1297, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        if (parent instanceof ChangeBlock) {
            return SpongeEventFactory.createDropItemEventDestruct((Cause)currentCause, collect.stream().map(t -> (Entity)t.first()).collect(Collectors.toList()));
        }
        return super.createSpawnEvent(context, parent, collect, currentCause);
    }
}

