/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2596;
import net.minecraft.class_2797;
import net.minecraft.class_2799;
import net.minecraft.class_2805;
import net.minecraft.class_2811;
import net.minecraft.class_2813;
import net.minecraft.class_2815;
import net.minecraft.class_2817;
import net.minecraft.class_2824;
import net.minecraft.class_2827;
import net.minecraft.class_2828;
import net.minecraft.class_2840;
import net.minecraft.class_2842;
import net.minecraft.class_2846;
import net.minecraft.class_2848;
import net.minecraft.class_2851;
import net.minecraft.class_2856;
import net.minecraft.class_2868;
import net.minecraft.class_2873;
import net.minecraft.class_2877;
import net.minecraft.class_2879;
import net.minecraft.class_2884;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_3222;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundInteractPacketAccessor;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryAddSlotState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryStartState;
import org.spongepowered.common.event.tracking.phase.packet.drag.MiddleDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.PrimaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.SecondaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CloseWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CreativeInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DoubleClickInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemInsideWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemOutsideWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemWithHotkeyState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.EnchantItemPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.MiddleInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.OpenInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PlaceRecipePacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryShiftClick;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryShiftClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SetCarriedItemState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwapHandItemsState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwitchHotbarNumberPressState;
import org.spongepowered.common.event.tracking.phase.packet.player.AnimationPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.AttackEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.IgnoredPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractAtEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InvalidPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.MovementPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.PacketCommandState;
import org.spongepowered.common.event.tracking.phase.packet.player.PlaceBlockPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.PlayerCommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.player.StopSleepingPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UnknownPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UseItemPacketState;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public final class PacketPhase {
    private final Map<Class<? extends class_2596<?>>, Function<class_2596<?>, IPhaseState<? extends PacketContext<?>>>> packetTranslationMap = new IdentityHashMap();
    private static final ImmutableMap<class_2848.class_2849, IPhaseState<? extends PacketContext<?>>> PLAYER_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)class_2848.class_2849.field_12979, General.PRESS_SHIFT_KEY).put((Object)class_2848.class_2849.field_12984, General.RELEASE_SHIFT_KEY).put((Object)class_2848.class_2849.field_12986, General.STOP_SLEEPING).put((Object)class_2848.class_2849.field_12981, General.START_SPRINTING).put((Object)class_2848.class_2849.field_12985, General.STOP_SPRINTING).put((Object)class_2848.class_2849.field_12987, General.START_RIDING_JUMP).put((Object)class_2848.class_2849.field_12980, General.STOP_RIDING_JUMP).put((Object)class_2848.class_2849.field_12988, (Object)Inventory.OPEN_INVENTORY).put((Object)class_2848.class_2849.field_12982, General.START_FALL_FLYING).build();
    private static final ImmutableMap<class_2846.class_2847, IPhaseState<? extends PacketContext<?>>> INTERACTION_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)class_2846.class_2847.field_12975, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)class_2846.class_2847.field_12970, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)class_2846.class_2847.field_12968, General.INTERACTION).put((Object)class_2846.class_2847.field_12971, General.INTERACTION).put((Object)class_2846.class_2847.field_12973, General.INTERACTION).put((Object)class_2846.class_2847.field_12974, General.INTERACTION).put((Object)class_2846.class_2847.field_12969, (Object)Inventory.SWAP_HAND_ITEMS).build();

    boolean isPacketInvalid(class_2596<?> packetIn, class_3222 packetPlayer, IPhaseState<? extends PacketContext<?>> packetState) {
        return ((PacketState)packetState).isPacketIgnored(packetIn, packetPlayer);
    }

    IPhaseState<? extends PacketContext<?>> getStateForPacket(class_2596<?> packet) {
        Function<class_2596<?>, IPhaseState<PacketContext<?>>> packetStateFunction = this.packetTranslationMap.get(packet.getClass());
        if (packetStateFunction != null) {
            return packetStateFunction.apply(packet);
        }
        return General.UNKNOWN;
    }

    public PhaseContext<?> populateContext(class_2596<?> packet, class_3222 entityPlayerMP, IPhaseState<?> state, PhaseContext<?> context) {
        Objects.requireNonNull(packet, "Packet cannot be null!");
        Preconditions.checkArgument(!context.isComplete(), "PhaseContext cannot be marked as completed!");
        ((PacketState)state).populateContext(entityPlayerMP, packet, (PacketContext)context);
        return context;
    }

    private static BasicInventoryPacketState fromWindowPacket(class_2813 windowPacket) {
        int mode = 512 << windowPacket.method_12195().ordinal();
        int packed = windowPacket.method_12193();
        int unpacked = mode == Constants.Networking.MODE_DRAG ? 64 << (packed >> 2 & 3) | 8 << (packed & 3) : 1 << (packed & 3);
        BasicInventoryPacketState inventory = PacketPhase.fromState(PacketPhase.clickType(windowPacket.method_12192()) | mode | unpacked);
        if (inventory == Inventory.INVENTORY) {
            SpongeCommon.logger().warn(String.format("Unable to find InventoryPacketState handler for click window packet: %s", windowPacket));
        }
        return inventory;
    }

    private static int clickType(int slotId) {
        return slotId == -999 || slotId == -1 ? 131072 : 65536;
    }

    private static BasicInventoryPacketState fromState(int state) {
        for (BasicInventoryPacketState inventory : Inventory.VALUES) {
            if (!inventory.matches(state)) continue;
            return inventory;
        }
        return Inventory.INVENTORY;
    }

    public static PacketPhase getInstance() {
        return Holder.INSTANCE;
    }

    PacketPhase() {
        this.setupPacketToStateMapping();
    }

    private void setupPacketToStateMapping() {
        this.packetTranslationMap.put(class_2827.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(class_2797.class, packet -> General.CHAT_COMMAND);
        this.packetTranslationMap.put(class_2824.class, packet -> {
            class_2824 useEntityPacket = (class_2824)packet;
            class_2824.class_5907 action = ((ServerboundInteractPacketAccessor)useEntityPacket).accessor$action().method_34211();
            if (action == class_2824.class_5907.field_29171) {
                return General.INTERACT_ENTITY;
            }
            if (action == class_2824.class_5907.field_29172) {
                return General.ATTACK_ENTITY;
            }
            if (action == class_2824.class_5907.field_29173) {
                return General.INTERACT_AT_ENTITY;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(class_2828.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(class_2828.class_2829.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(class_2828.class_2831.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(class_2828.class_2830.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(class_2846.class, packet -> {
            class_2846 playerDigging = (class_2846)packet;
            class_2846.class_2847 action = playerDigging.method_12363();
            IPhaseState state = (IPhaseState)INTERACTION_ACTION_MAPPINGS.get((Object)action);
            return state == null ? General.UNKNOWN : state;
        });
        this.packetTranslationMap.put(class_2885.class, packet -> General.PLACE_BLOCK);
        this.packetTranslationMap.put(class_2886.class, packet -> General.USE_ITEM);
        this.packetTranslationMap.put(class_2868.class, packet -> Inventory.SET_CARRIED_ITEM);
        this.packetTranslationMap.put(class_2879.class, packet -> General.ANIMATION);
        this.packetTranslationMap.put(class_2848.class, packet -> {
            class_2848 playerAction = (class_2848)packet;
            class_2848.class_2849 action = playerAction.method_12365();
            return (IPhaseState)PLAYER_ACTION_MAPPINGS.get((Object)action);
        });
        this.packetTranslationMap.put(class_2851.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(class_2815.class, packet -> General.CLOSE_WINDOW);
        this.packetTranslationMap.put(class_2813.class, packet -> PacketPhase.fromWindowPacket((class_2813)packet));
        this.packetTranslationMap.put(class_2873.class, packet -> General.CREATIVE_INVENTORY);
        this.packetTranslationMap.put(class_2811.class, packet -> Inventory.ENCHANT_ITEM);
        this.packetTranslationMap.put(class_2877.class, packet -> General.UPDATE_SIGN);
        this.packetTranslationMap.put(class_2842.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(class_2805.class, packet -> General.TAB_COMPLETE);
        this.packetTranslationMap.put(class_2799.class, packet -> {
            class_2799 clientStatus = (class_2799)packet;
            class_2799.class_2800 status = clientStatus.method_12119();
            if (status == class_2799.class_2800.field_12774) {
                return General.REQUEST_RESPAWN;
            }
            return General.IGNORED;
        });
        this.packetTranslationMap.put(class_2817.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(class_2884.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(class_2856.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(class_2840.class, packet -> Inventory.PLACE_RECIPE);
    }

    public static final class General {
        public static final IPhaseState<BasicPacketContext> UNKNOWN = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> MOVEMENT = new MovementPacketState();
        static final IPhaseState<InteractionPacketContext> INTERACTION = new InteractionPacketState();
        static final IPhaseState<BasicPacketContext> IGNORED = new IgnoredPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_ENTITY = new InteractEntityPacketState();
        static final IPhaseState<BasicPacketContext> ATTACK_ENTITY = new AttackEntityPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_AT_ENTITY = new InteractAtEntityPacketState();
        static final IPhaseState<BasicPacketContext> CREATIVE_INVENTORY = new CreativeInventoryPacketState();
        static final IPhaseState<BasicPacketContext> PLACE_BLOCK = new PlaceBlockPacketState();
        static final IPhaseState<BasicPacketContext> REQUEST_RESPAWN = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> USE_ITEM = new UseItemPacketState();
        static final IPhaseState<BasicPacketContext> INVALID = new InvalidPacketState();
        static final IPhaseState<BasicPacketContext> START_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> ANIMATION = new AnimationPacketState();
        static final IPhaseState<BasicPacketContext> PRESS_SHIFT_KEY = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> RELEASE_SHIFT_KEY = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> START_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SLEEPING = new StopSleepingPacketState();
        static final IPhaseState<BasicPacketContext> TAB_COMPLETE = new BasicPacketState();
        static final CloseWindowState CLOSE_WINDOW = new CloseWindowState();
        public static final IPhaseState<BasicPacketContext> UPDATE_SIGN = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> HANDLED_EXTERNALLY = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> START_FALL_FLYING = new BasicPacketState();
        static final IPhaseState<PlayerCommandPhaseContext> CHAT_COMMAND = new PacketCommandState();
    }

    public static final class Inventory {
        static final BasicInventoryPacketState INVENTORY = new BasicInventoryPacketState();
        static final BasicInventoryPacketState PRIMARY_INVENTORY_CLICK = new PrimaryInventoryClickState();
        static final BasicInventoryPacketState SECONDARY_INVENTORY_CLICK = new SecondaryInventoryClickState();
        static final BasicInventoryPacketState MIDDLE_INVENTORY_CLICK = new MiddleInventoryClickState();
        static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW = new DropItemOutsideWindowState(Constants.Networking.MODE_CLICK | 1 | 2 | 0x20000);
        static final BasicInventoryPacketState DROP_ITEM_INSIDE_WINDOW = new DropItemInsideWindowState();
        static final BasicInventoryPacketState DROP_ITEM_WITH_HOTKEY = new DropItemWithHotkeyState();
        static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW_NOOP = new DropItemOutsideWindowState(Constants.Networking.MODE_DROP | 1 | 2 | 0x20000);
        static final BasicInventoryPacketState DROP_ITEMS = new BasicInventoryPacketState();
        static final BasicInventoryPacketState DROP_INVENTORY = new DropInventoryState();
        static final BasicInventoryPacketState SWITCH_HOTBAR_NUMBER_PRESS = new SwitchHotbarNumberPressState();
        static final BasicInventoryPacketState PRIMARY_INVENTORY_SHIFT_CLICK = new PrimaryInventoryShiftClick();
        static final BasicInventoryPacketState SECONDARY_INVENTORY_SHIFT_CLICK = new SecondaryInventoryShiftClickState();
        static final BasicInventoryPacketState DOUBLE_CLICK_INVENTORY = new DoubleClickInventoryState();
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_START = new DragInventoryStartState("PRIMARY_DRAG_INVENTORY_START", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_START = new DragInventoryStartState("SECONDARY_DRAG_INVENTORY_START", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_START = new DragInventoryStartState("MIDDLE_DRAG_INVENTORY_START", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("PRIMARY_DRAG_INVENTORY_ADD_SLOT", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("SECONDARY_DRAG_INVENTORY_ADD_SLOT", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("MIDDLE_DRAG_INVENTORY_ADD_SLOT", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_STOP = new PrimaryDragInventoryStopState();
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_STOP = new SecondaryDragInventoryStopState();
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_STOP = new MiddleDragInventoryStopState();
        static final BasicInventoryPacketState SET_CARRIED_ITEM = new SetCarriedItemState();
        static final BasicInventoryPacketState OPEN_INVENTORY = new OpenInventoryState();
        static final BasicInventoryPacketState ENCHANT_ITEM = new EnchantItemPacketState();
        static final BasicInventoryPacketState SWAP_HAND_ITEMS = new SwapHandItemsState();
        static final BasicInventoryPacketState PLACE_RECIPE = new PlaceRecipePacketState();
        static final ImmutableList<BasicInventoryPacketState> VALUES = ImmutableList.builder().add((Object)INVENTORY).add((Object)PRIMARY_INVENTORY_CLICK).add((Object)SECONDARY_INVENTORY_CLICK).add((Object)MIDDLE_INVENTORY_CLICK).add((Object)DROP_ITEM_OUTSIDE_WINDOW).add((Object)DROP_ITEM_INSIDE_WINDOW).add((Object)DROP_ITEM_OUTSIDE_WINDOW_NOOP).add((Object)DROP_ITEMS).add((Object)DROP_INVENTORY).add((Object)SWITCH_HOTBAR_NUMBER_PRESS).add((Object)PRIMARY_INVENTORY_SHIFT_CLICK).add((Object)SECONDARY_INVENTORY_SHIFT_CLICK).add((Object)DOUBLE_CLICK_INVENTORY).add((Object)PRIMARY_DRAG_INVENTORY_START).add((Object)SECONDARY_DRAG_INVENTORY_START).add((Object)MIDDLE_DRAG_INVENTORY_START).add((Object)PRIMARY_DRAG_INVENTORY_ADDSLOT).add((Object)SECONDARY_DRAG_INVENTORY_ADDSLOT).add((Object)MIDDLE_DRAG_INVENTORY_ADDSLOT).add((Object)PRIMARY_DRAG_INVENTORY_STOP).add((Object)SECONDARY_DRAG_INVENTORY_STOP).add((Object)MIDDLE_DRAG_INVENTORY_STOP).add((Object)SET_CARRIED_ITEM).add((Object)OPEN_INVENTORY).add((Object)ENCHANT_ITEM).build();
    }

    private static final class Holder {
        static final PacketPhase INSTANCE = new PacketPhase();

        private Holder() {
        }
    }
}

