/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1492;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2803;
import net.minecraft.class_2828;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_9334;
import net.minecraft.class_9834;
import net.minecraft.class_9835;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.accessor.entity.passive.AbstractChestedHorseEntityAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMovePlayerPacketAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.entity.animal.PigAccessor;
import org.spongepowered.common.accessor.world.entity.animal.SheepAccessor;
import org.spongepowered.common.accessor.world.entity.animal.WolfAccessor;
import org.spongepowered.common.accessor.world.inventory.SlotAccessor;
import org.spongepowered.common.bridge.network.protocol.PacketBridge;
import org.spongepowered.common.bridge.world.level.block.TrackableBlockBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class PacketPhaseUtil {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void handleSlotRestore(@Nullable class_1657 player, @Nullable class_1703 containerMenu, List<SlotTransaction> slotTransactions, boolean eventCancelled) {
        PhaseTracker phaseTracker = player != null ? PhaseTracker.getWorldInstance((class_3218)player.method_37908()) : PhaseTracker.getWorldInstance();
        try (@NonNull P ignored = ((PhaseContext)BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(phaseTracker)).buildAndSwitch();){
            boolean restoredAny = false;
            for (SlotTransaction slotTransaction : slotTransactions) {
                int slotNumber;
                class_1735 nmsSlot;
                ItemStackSnapshot snapshot;
                if (!slotTransaction.custom().isPresent() && slotTransaction.isValid() && !eventCancelled) continue;
                restoredAny = true;
                Slot slot = slotTransaction.slot();
                ItemStackSnapshot itemStackSnapshot = snapshot = eventCancelled || !slotTransaction.isValid() ? (ItemStackSnapshot)slotTransaction.original() : (ItemStackSnapshot)slotTransaction.custom().get();
                if (containerMenu == null || slot.viewedSlot() instanceof class_1735) {
                    slot.set((ItemStackLike)snapshot);
                    continue;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (containerMenu != player.field_7498 && serverPlayer.inventory().containsInventory((Inventory)slot)) {
                        ItemStack stack = snapshot.asMutable();
                        slot.set((ItemStackLike)stack);
                        ((class_3222)player).field_13987.method_14364((class_2596)new class_9835(((SlotAdapter)slot).getOrdinal(), ItemStackUtil.toNative(stack)));
                        continue;
                    }
                }
                if ((nmsSlot = containerMenu.method_7611(slotNumber = ((SlotAdapter)slot).getOrdinal())) == null) continue;
                nmsSlot.method_7673(ItemStackUtil.fromSnapshotToNative(snapshot));
            }
            if (restoredAny && player instanceof class_3222) {
                if (containerMenu != null) {
                    containerMenu.method_7623();
                    if (player.field_7512 == containerMenu) {
                        containerMenu.method_34252();
                    }
                } else {
                    player.field_7498.method_7623();
                }
            }
        }
    }

    public static void handleCursorRestore(class_1657 player, Transaction<ItemStackSnapshot> cursorTransaction, boolean eventCancelled) {
        ItemStackSnapshot cursorSnap;
        if (eventCancelled || !cursorTransaction.isValid()) {
            cursorSnap = (ItemStackSnapshot)cursorTransaction.original();
        } else if (cursorTransaction.custom().isPresent()) {
            cursorSnap = (ItemStackSnapshot)cursorTransaction.finalReplacement();
        } else {
            return;
        }
        class_1799 cursor = ItemStackUtil.fromSnapshotToNative(cursorSnap);
        player.field_7512.method_34254(cursor);
        player.field_7512.method_34250(cursor);
        if (player instanceof class_3222) {
            ((class_3222)player).field_13987.method_14364((class_2596)new class_9834(cursor));
        }
    }

    public static void handleCustomCursor(class_1657 player, ItemStackSnapshot customCursor) {
        class_1799 cursor = ItemStackUtil.fromSnapshotToNative(customCursor);
        player.field_7512.method_34254(cursor);
        if (player instanceof class_3222) {
            ((class_3222)player).field_13987.method_14364((class_2596)new class_9834(cursor));
        }
    }

    public static void validateCapturedTransactions(int slotId, class_1703 containerMenu, List<SlotTransaction> capturedTransactions) {
        class_1735 slot;
        if (capturedTransactions.size() == 0 && slotId >= 0 && slotId < containerMenu.field_7761.size() && (slot = containerMenu.method_7611(slotId)) != null) {
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(slot.method_7677());
            SlotTransaction slotTransaction = new SlotTransaction(((InventoryAdapter)containerMenu).inventoryAdapter$getSlot(slotId).get(), snapshot, snapshot);
            capturedTransactions.add(slotTransaction);
        }
    }

    public static void handlePlayerSlotRestore(class_3222 player, class_1799 itemStack, class_1268 hand) {
        if (itemStack.method_7960()) {
            return;
        }
        player.field_7512.method_34256();
        int slotId = 0;
        if (hand == class_1268.field_5810) {
            player.method_31548().field_7544.set(0, (Object)itemStack);
            slotId = player.method_31548().field_7547.size() + class_1661.method_7368();
        } else {
            player.method_31548().field_7547.set(player.method_31548().field_7545, (Object)itemStack);
            for (class_1735 containerSlot : player.field_7512.field_7761) {
                if (containerSlot.field_7871 != player.method_31548() || ((SlotAccessor)containerSlot).accessor$slot() != player.method_31548().field_7545) continue;
                slotId = containerSlot.field_7874;
                break;
            }
        }
        player.field_7512.method_7623();
        player.field_7512.method_34257();
        player.field_13987.method_14364((class_2596)new class_2653(player.field_7512.field_7763, player.field_7512.method_37421(), slotId, itemStack));
    }

    public static boolean allTransactionsInvalid(List<SlotTransaction> slotTransactions) {
        if (slotTransactions.size() == 0) {
            return false;
        }
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.isValid()) continue;
            return false;
        }
        return true;
    }

    public static void onProcessPacket(class_2596 packetIn, class_2547 netHandler) {
        if (netHandler instanceof class_3244) {
            class_3222 packetPlayer = ((class_3244)netHandler).field_14140;
            if (!packetPlayer.method_5805() && !((PacketBridge)packetIn).bridge$canProcessWhenDead()) {
                return;
            }
            try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
                boolean ignoreMovementCapture;
                frame.pushCause((Object)packetPlayer);
                if (packetIn instanceof class_2828) {
                    class_2828 movingPacket = (class_2828)packetIn;
                    ignoreMovementCapture = movingPacket instanceof class_2828.class_2831 ? true : packetPlayer.method_23317() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$x() && packetPlayer.method_23318() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$y() && packetPlayer.method_23321() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$z();
                    if (ignoreMovementCapture) {
                        class_238 boundingBox = packetPlayer.method_5829();
                        class_2338 min = new class_2338((int)(boundingBox.field_1323 + 0.001), (int)(boundingBox.field_1322 + 0.001), (int)(boundingBox.field_1321 + 0.001));
                        class_2338 max = new class_2338((int)(boundingBox.field_1320 - 0.001), (int)(boundingBox.field_1325 - 0.001), (int)(boundingBox.field_1324 - 0.001));
                        class_2338.class_2339 pos = new class_2338.class_2339();
                        if (packetPlayer.method_37908().method_22343(min, max)) {
                            for (int x = min.method_10263(); x <= max.method_10263(); ++x) {
                                for (int y = min.method_10264(); y <= max.method_10264(); ++y) {
                                    for (int z = min.method_10260(); z <= max.method_10260(); ++z) {
                                        pos.method_10103(x, y, z);
                                        class_2248 block = packetPlayer.method_37908().method_8320((class_2338)pos).method_26204();
                                        if (!((TrackableBlockBridge)block).bridge$hasEntityInsideLogic()) continue;
                                        ignoreMovementCapture = false;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    ignoreMovementCapture = false;
                }
                if (ignoreMovementCapture || packetIn instanceof class_2803) {
                    packetIn.method_11054(netHandler);
                }
                IPhaseState<PacketContext<?>> packetState = PacketPhase.getInstance().getStateForPacket(packetIn);
                PacketContext<?> context = packetState.createPhaseContext(PhaseTracker.getWorldInstance(packetPlayer.method_51469()));
                ((PacketContext)((PacketContext)context.source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn);
                if (!PacketPhase.getInstance().isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    PacketPhase.getInstance().populateContext(packetIn, packetPlayer, packetState, context);
                    context.creator(((ServerPlayer)packetPlayer).uniqueId());
                    context.notifier(((ServerPlayer)packetPlayer).uniqueId());
                }
                try (PacketContext<?> packetContext = context;){
                    packetContext.buildAndSwitch();
                    packetIn.method_11054(netHandler);
                }
            }
        } else {
            packetIn.method_11054(netHandler);
        }
    }

    public static @Nullable class_2940<?> findModifiedEntityInteractDataParameter(class_1799 stack, class_1297 entity) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1769) {
            if (entity instanceof class_1472) {
                return SheepAccessor.accessor$DATA_WOOL_ID();
            }
            if (entity instanceof class_1493) {
                return WolfAccessor.accessor$DATA_COLLAR_COLOR();
            }
            return null;
        }
        if (item == class_1802.field_8448) {
            return entity instanceof class_1309 && !(entity instanceof class_1657) && stack.method_57826(class_9334.field_49631) ? EntityAccessor.accessor$DATA_CUSTOM_NAME() : null;
        }
        if (item == class_1802.field_8175) {
            return entity instanceof class_1452 ? PigAccessor.accessor$DATA_SADDLE_ID() : null;
        }
        if (item instanceof class_1747 && ((class_1747)item).method_7711() == class_2246.field_10034) {
            return entity instanceof class_1492 ? AbstractChestedHorseEntityAccessor.accessor$DATA_ID_CHEST() : null;
        }
        return null;
    }
}

