/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.bridge.server.TickTaskBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;

public abstract class PacketState<P extends PacketContext<P>>
extends PooledPhaseState<P>
implements IPhaseState<P> {
    private final BiConsumer<CauseStackManager.StackFrame, P> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.packetPlayer != null) {
            frame.pushCause((Object)ctx.packetPlayer);
        }
    });
    private final String desc = TrackingUtil.phaseStateToString("Packet", this);

    protected PacketState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, P> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public void unwind(P phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    public boolean matches(int packetState) {
        return false;
    }

    @Override
    public void associateNeighborStateNotifier(P unwindingContext, class_2338 sourcePos, class_2248 block, class_2338 notifyPos, class_3218 minecraftWorld, PlayerTracker.Type notifier) {
        ServerPlayer player = ((PacketContext)unwindingContext).getSpongePlayer();
        class_2818 chunk = minecraftWorld.method_8500(notifyPos);
        ((LevelChunkBridge)chunk).bridge$setBlockNotifier(notifyPos, player.uniqueId());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(P context, class_1297 entityToSpawn) {
        return SpawnTypes.PLACEMENT;
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(P context) {
        class_2960 worldKey = ((PacketContext)context).packetPlayer.method_37908().method_27983().method_29177();
        return () -> (ResourceKey)worldKey;
    }

    public void populateContext(class_3222 playerMP, class_2596<?> packet, P context) {
    }

    public boolean isPacketIgnored(class_2596<?> packetIn, class_3222 packetPlayer) {
        return false;
    }

    protected boolean alwaysUnwinds() {
        return false;
    }

    @Override
    public void foldContextForThread(P context, TickTaskBridge returnValue) {
        @Nullable class_3222 source = ((PacketContext)context).getPacketPlayer();
        returnValue.bridge$contextShift((c, f) -> {
            if (source != null) {
                f.pushCause((Object)source);
            }
        });
    }

    public String toString() {
        return this.desc;
    }
}

