/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;

public class BasicInventoryPacketState
extends PacketState<InventoryPacketContext> {
    final int stateId;
    final int stateMask;

    public BasicInventoryPacketState() {
        this(0, 0);
    }

    public BasicInventoryPacketState(int stateId) {
        this(stateId, 262143);
    }

    public BasicInventoryPacketState(int stateId, int stateMask) {
        this.stateId = stateId & stateMask;
        this.stateMask = stateMask;
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, InventoryPacketContext> getFrameModifier() {
        return super.getFrameModifier().andThen((frame, context) -> {
            class_3222 player = context.getPacketPlayer();
            class_1703 openContainer = player.field_7512;
            frame.pushCause((Object)openContainer);
            frame.pushCause((Object)player);
        });
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(InventoryPacketContext context, class_1297 entityToSpawn) {
        return SpawnTypes.DROPPED_ITEM;
    }

    protected boolean shouldFire() {
        return ShouldFire.CLICK_CONTAINER_EVENT;
    }

    @Override
    public boolean matches(int packetState) {
        return this.stateMask != 0 && (packetState & this.stateMask & this.stateId) == (packetState & this.stateMask);
    }

    @Override
    public void populateContext(class_3222 playerMP, class_2596<?> packet, InventoryPacketContext context) {
    }

    @Override
    public InventoryPacketContext createNewContext(PhaseTracker tracker) {
        return new InventoryPacketContext(this, tracker);
    }
}

