/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_2596;
import net.minecraft.class_2824;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class AttackEntityPacketState
extends BasicPacketState {
    private final BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> ATTACK_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.USED_ITEM, (Object)ctx.getItemUsedSnapshot());
        class_2824 useEntityPacket = (class_2824)ctx.getPacket();
        class_3222 player = ctx.getPacketPlayer();
        @Nullable class_1297 entity = useEntityPacket.method_12248(player.method_51469());
        if (entity != null) {
            frame.addContext(EventContextKeys.USED_HAND, (Object)ctx.getHandUsed());
            frame.pushCause((Object)entity);
        }
        frame.pushCause((Object)player);
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.ATTACK_MODIFIER;
    }

    @Override
    public boolean isPacketIgnored(class_2596<?> packetIn, class_3222 packetPlayer) {
        class_2824 useEntityPacket = (class_2824)packetIn;
        @Nullable class_1297 entity = useEntityPacket.method_12248((class_3218)packetPlayer.method_37908());
        return entity == null;
    }

    @Override
    public void populateContext(class_3222 playerMP, class_2596<?> packet, BasicPacketContext context) {
        ((BasicPacketContext)context.itemUsed(ItemStackUtil.cloneDefensive(playerMP.method_6047()))).handUsed((HandType)HandTypes.MAIN_HAND.get());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, class_1297 entityToSpawn) {
        class_3222 player;
        class_2824 useEntityPacket = (class_2824)context.getPacket();
        @Nullable class_1297 entity = useEntityPacket.method_12248((player = context.getPacketPlayer()).method_51469());
        if (entity != null && (entity.method_31481() || entity instanceof class_1309 && ((class_1309)entity).method_29504())) {
            return entityToSpawn instanceof class_1303 ? SpawnTypes.EXPERIENCE : SpawnTypes.DROPPED_ITEM;
        }
        if (entityToSpawn instanceof class_1542) {
            return SpawnTypes.DROPPED_ITEM;
        }
        return super.getSpawnTypeForTransaction(context, entityToSpawn);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        class_3222 player;
        class_2824 useEntityPacket;
        class_1297 entity;
        if (!TrackingUtil.processBlockCaptures(context) && (entity = (useEntityPacket = (class_2824)context.getPacket()).method_12248((player = context.getPacketPlayer()).method_51469())) instanceof Entity) {
            ((Entity)entity).offer(Keys.NOTIFIER, (Object)player.method_5667());
        }
    }
}

