/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_3222;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class InteractionPacketState
extends PacketState<InteractionPacketContext> {
    @Override
    public BiConsumer<CauseStackManager.StackFrame, InteractionPacketContext> getFrameModifier() {
        return super.getFrameModifier().andThen((frame, context) -> {
            ItemStack usedStack = context.getItemUsed();
            HandType usedHand = context.getHandUsed();
            ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf((ItemStackLike)usedStack);
            BlockSnapshot targetBlock = context.getTargetBlock();
            frame.addContext(EventContextKeys.USED_ITEM, (Object)usedSnapshot);
            frame.addContext(EventContextKeys.USED_HAND, (Object)usedHand);
            frame.addContext(EventContextKeys.BLOCK_HIT, (Object)targetBlock);
        });
    }

    @Override
    public InteractionPacketContext createNewContext(PhaseTracker tracker) {
        return new InteractionPacketContext(this, tracker);
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(class_3222 playerMP, class_2596<?> packet, InteractionPacketContext context) {
        ItemStack itemInUse;
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.method_6047());
        if (stack != null) {
            context.itemUsed(stack);
        }
        if ((itemInUse = ItemStackUtil.cloneDefensive(playerMP.method_6030())) != null) {
            context.activeItem(itemInUse);
        }
        class_2338 target = ((class_2846)packet).method_12362();
        if (!playerMP.method_37908().method_8477(target)) {
            context.targetBlock(BlockSnapshot.empty());
        } else {
            context.targetBlock(((TrackedWorldBridge)playerMP.method_37908()).bridge$createSnapshot(target, BlockChangeFlags.NONE));
        }
        context.handUsed((HandType)HandTypes.MAIN_HAND.get());
    }

    @Override
    public void unwind(InteractionPacketContext phaseContext) {
        boolean hasBlocks;
        class_3222 player = phaseContext.getPacketPlayer();
        class_1799 endActiveItem = player.method_6030();
        ((LivingEntityAccessor)player).accessor$useItem(ItemStackUtil.toNative(phaseContext.getActiveItem()));
        boolean bl = hasBlocks = !phaseContext.getTransactor().isEmpty();
        if (hasBlocks && !TrackingUtil.processBlockCaptures(phaseContext)) {
            return;
        }
        ((LivingEntityAccessor)player).accessor$useItem(endActiveItem);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(InteractionPacketContext context, class_1297 entityToSpawn) {
        return SpawnTypes.DROPPED_ITEM;
    }
}

