/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2885;
import net.minecraft.class_3222;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

public final class PlaceBlockPacketState
extends BasicPacketState {
    private final BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, (Object)ctx.getSpongePlayer().world());
        frame.addContext(EventContextKeys.USED_HAND, (Object)ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, (Object)ctx.getItemUsedSnapshot());
        frame.pushCause((Object)ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(class_3222 playerMP, class_2596<?> packet, BasicPacketContext context) {
        class_2885 placeBlock = (class_2885)packet;
        class_1799 itemUsed = playerMP.method_5998(placeBlock.method_12546());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.method_12546();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BasicPacketContext context, ServerWorld serverWorld, BlockChange blockChange, BlockTransactionReceipt transaction) {
        TrackingUtil.associateTrackerToTarget(blockChange, transaction, ((ServerPlayer)context.getPacketPlayer()).uniqueId());
    }

    @Override
    public void appendNotifierToBlockEvent(BasicPacketContext context, TrackedWorldBridge mixinWorldServer, class_2338 pos, TrackableBlockEventDataBridge blockEvent) {
        Player player = (Player)PhaseTracker.getInstance().currentCause().first(Player.class).get();
        BlockState state = ((ServerWorld)mixinWorldServer).block(pos.method_10263(), pos.method_10264(), pos.method_10260());
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)mixinWorldServer).position(pos.method_10263(), pos.method_10264(), pos.method_10260()).state(state).build();
        blockEvent.bridge$setTickingLocatable(locatable);
        blockEvent.bridge$setSourceUserUUID(player.uniqueId());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, class_1297 entityToSpawn) {
        ItemStack itemStack = context.getItemUsed();
        return itemStack.type() instanceof class_1826 ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT;
    }
}

