/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2886;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

public final class UseItemPacketState
extends BasicPacketState {
    private BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, (Object)ctx.getSpongePlayer().world());
        frame.addContext(EventContextKeys.USED_HAND, (Object)ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, (Object)ctx.getItemUsedSnapshot());
        frame.pushCause((Object)ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(class_3222 playerMP, class_2596<?> packet, BasicPacketContext context) {
        class_2886 placeBlock = (class_2886)packet;
        class_1799 usedItem = playerMP.method_5998(placeBlock.method_12551());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(usedItem);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.method_12551();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BasicPacketContext context, ServerWorld serverWorld, BlockChange blockChange, BlockTransactionReceipt transaction) {
        ServerPlayer player = context.getSpongePlayer();
        class_2338 pos = VecHelper.toBlockPos(transaction.finalBlock().position());
        LevelChunkBridge spongeChunk = (LevelChunkBridge)((class_3218)player.world()).method_8500(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.bridge$addTrackedBlockPosition((class_2248)transaction.finalBlock().state().type(), pos, player.uniqueId(), PlayerTracker.Type.CREATOR);
        }
        spongeChunk.bridge$addTrackedBlockPosition((class_2248)transaction.finalBlock().state().type(), pos, player.uniqueId(), PlayerTracker.Type.NOTIFIER);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, class_1297 entityToSpawn) {
        ItemStack itemStack = context.getItemUsed();
        return itemStack.type() instanceof class_1826 ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT;
    }

    @Override
    public void unwind(BasicPacketContext context) {
        class_3222 player = context.getPacketPlayer();
        ItemStackSnapshot snapshot = context.getItemUsedSnapshot();
        HandType hand = context.getHandUsed();
        ItemStack itemStack = context.getItemUsed();
        boolean success = TrackingUtil.processBlockCaptures(context);
        if (!success && snapshot.isEmpty()) {
            PhaseTracker.getInstance().pushCause(player);
            PacketPhaseUtil.handlePlayerSlotRestore(player, ItemStackUtil.toNative(itemStack), (class_1268)hand);
        }
    }
}

