/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhaseContext;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.common.util.PrettyPrinter;

public class ListenerPhaseContext<L extends ListenerPhaseContext<L>>
extends PluginPhaseContext<L> {
    Object object;
    private CapturePlayer capturePlayer;

    ListenerPhaseContext(IPhaseState<L> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    @Override
    protected boolean isRunaway(PhaseContext<?> phaseContext) {
        return phaseContext instanceof ListenerPhaseContext && ((ListenerPhaseContext)phaseContext).object == this.object;
    }

    public L event(Object obj) {
        this.object = obj;
        return (L)this;
    }

    public L player() {
        Preconditions.checkState(!this.isCompleted, "Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState(this.capturePlayer == null, "Already capturing a player object!");
        this.capturePlayer = new CapturePlayer();
        return (L)this;
    }

    public CapturePlayer getCapturedPlayerSupplier() throws IllegalStateException {
        if (this.capturePlayer == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing a Player from an event listener, but we're not capturing them!", this).get();
        }
        return this.capturePlayer;
    }

    public Optional<Player> getCapturedPlayer() throws IllegalStateException {
        return this.getCapturedPlayerSupplier().getPlayer();
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent).add(s + "- %s: %s", "Listener", this.object);
        if (this.capturePlayer != null && this.capturePlayer.player != null) {
            printer.add(s + "- %s: %s", "CapturedPlayer", this.capturePlayer.player);
        }
        return printer;
    }

    @Override
    protected void reset() {
        super.reset();
        this.object = null;
        if (this.capturePlayer != null) {
            this.capturePlayer.player = null;
        }
    }

    public static final class CapturePlayer {
        @Nullable Player player;

        CapturePlayer() {
        }

        public Optional<Player> getPlayer() {
            return Optional.ofNullable(this.player);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturePlayer that = (CapturePlayer)o;
            return Objects.equals(this.player, that.player);
        }

        public int hashCode() {
            return Objects.hashCode(this.player);
        }

        public String toString() {
            return new StringJoiner(", ", CapturePlayer.class.getSimpleName() + "[", "]").add("player=" + String.valueOf(this.player)).toString();
        }

        public void addPlayer(class_3222 playerMP) {
            this.player = (Player)playerMP;
        }
    }
}

