/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.world.BlockChange;

class BlockEventTickPhaseState
extends TickPhaseState<BlockEventTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> FRAME_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        TrackableBlockEventDataBridge blockEventData = context.getSource(TrackableBlockEventDataBridge.class).orElse(null);
        if (blockEventData != null) {
            if (blockEventData.bridge$getTileEntity() != null) {
                frame.pushCause((Object)blockEventData.bridge$getTileEntity());
            } else if (blockEventData.bridge$getTickingLocatable() != null) {
                frame.pushCause((Object)blockEventData.bridge$getTickingLocatable());
                frame.addContext(EventContextKeys.BLOCK_EVENT_PROCESS, (Object)blockEventData.bridge$getTickingLocatable());
            }
        }
    });

    BlockEventTickPhaseState() {
    }

    @Override
    public BlockEventTickContext createNewContext(PhaseTracker tracker) {
        return new BlockEventTickContext(tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    public void associateNeighborStateNotifier(BlockEventTickContext context, @Nullable class_2338 sourcePos, class_2248 block, class_2338 notifyPos, class_3218 minecraftWorld, PlayerTracker.Type notifier) {
        context.applyNotifierIfAvailable(user -> {
            LevelChunkBridge mixinChunk = (LevelChunkBridge)minecraftWorld.method_8500(notifyPos);
            mixinChunk.bridge$addTrackedBlockPosition(block, notifyPos, (UUID)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public void postBlockTransactionApplication(BlockEventTickContext context, ServerWorld serverWorld, BlockChange blockChange, BlockTransactionReceipt receipt) {
        class_2248 block = (class_2248)receipt.originalBlock().state().type();
        SpongeBlockSnapshot original = (SpongeBlockSnapshot)receipt.originalBlock();
        class_2338 changedBlockPos = original.getBlockPos();
        original.getServerWorld().ifPresent(worldServer -> {
            LevelChunkBridge changedMixinChunk = (LevelChunkBridge)worldServer.method_8500(changedBlockPos);
            changedMixinChunk.bridge$getBlockCreatorUUID(changedBlockPos).ifPresent(owner -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)owner, PlayerTracker.Type.CREATOR));
            changedMixinChunk.bridge$getBlockNotifierUUID(changedBlockPos).ifPresent(user -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)user, PlayerTracker.Type.NOTIFIER));
        });
    }

    @Override
    public void unwind(BlockEventTickContext context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BlockEventTickContext context, class_1297 entityToSpawn) {
        return SpawnTypes.CUSTOM;
    }
}

