/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.entity.Breedable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.entity.decoration.ItemFrameAccessor;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.TrackableEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState<EntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, EntityTickContext> ENTITY_TICK_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        Entity tickingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        ((TrackableEntityBridge)tickingEntity).tracker$populateFrameInTickContext((CauseStackManager.StackFrame)frame, (EntityTickContext)context);
        frame.pushCause((Object)tickingEntity);
    });

    EntityTickPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, EntityTickContext> getFrameModifier() {
        return this.ENTITY_TICK_MODIFIER;
    }

    @Override
    public void unwind(EntityTickContext phaseContext) {
        Entity tickingEntity = phaseContext.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        if (!TrackingUtil.processBlockCaptures(phaseContext)) {
            ((EntityBridge)tickingEntity).bridge$onCancelledBlockChange(phaseContext);
        }
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(EntityTickContext context, class_1297 entityToSpawn) {
        if (entityToSpawn instanceof ExperienceOrb) {
            return SpawnTypes.EXPERIENCE;
        }
        if (entityToSpawn instanceof Projectile) {
            return SpawnTypes.PROJECTILE;
        }
        Entity source = context.getSource(Entity.class).orElseThrow(() -> new IllegalStateException("Ticking over a non Entity"));
        if (source instanceof Breedable && source.getClass() == entityToSpawn.getClass()) {
            return SpawnTypes.BREEDING;
        }
        return super.getSpawnTypeForTransaction(context, entityToSpawn);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(EntityTickContext context) {
        class_1297 entity = context.getSource(class_1297.class).orElseThrow(() -> new IllegalStateException("Expected to be ticking an entity, but we're not ticking an entity"));
        if (entity.method_37908().field_9236) {
            return () -> {
                throw new IllegalStateException("attempting a world key on the client???");
            };
        }
        return () -> (ResourceKey)entity.method_37908().method_27983().method_29177();
    }

    @Override
    protected EntityTickContext createNewContext(PhaseTracker tracker) {
        return new EntityTickContext(this, tracker);
    }

    @Override
    public void postBlockTransactionApplication(EntityTickContext context, ServerWorld serverWorld, BlockChange blockChange, BlockTransactionReceipt transaction) {
        if (blockChange == BlockChange.BREAK) {
            Entity tickingEntity = context.getSource(Entity.class).get();
            class_2338 blockPos = VecHelper.toBlockPos(transaction.originalBlock().position());
            class_243 aabbBase = VecHelper.toVanillaVector3d(transaction.originalBlock().position().toDouble());
            List hangingEntities = ((class_3218)tickingEntity.world()).method_8390(class_1530.class, new class_238(aabbBase, aabbBase).method_1009(1.1, 1.1, 1.1), entityIn -> {
                if (entityIn == null) {
                    return false;
                }
                class_2338 entityPos = entityIn.method_59940();
                if (entityPos.equals((Object)blockPos.method_10069(0, 1, 0))) {
                    return true;
                }
                class_2350 entityFacing = entityIn.method_5735();
                if (entityFacing == class_2350.field_11043) {
                    return entityPos.equals((Object)blockPos.method_10081((class_2382)Constants.Entity.HANGING_OFFSET_NORTH));
                }
                if (entityFacing == class_2350.field_11035) {
                    return entityIn.method_59940().equals((Object)blockPos.method_10081((class_2382)Constants.Entity.HANGING_OFFSET_SOUTH));
                }
                if (entityFacing == class_2350.field_11039) {
                    return entityIn.method_59940().equals((Object)blockPos.method_10081((class_2382)Constants.Entity.HANGING_OFFSET_WEST));
                }
                if (entityFacing == class_2350.field_11034) {
                    return entityIn.method_59940().equals((Object)blockPos.method_10081((class_2382)Constants.Entity.HANGING_OFFSET_EAST));
                }
                return false;
            });
            for (class_1530 entityHanging : hangingEntities) {
                if (!(entityHanging instanceof class_1533)) continue;
                class_1533 iframe = (class_1533)entityHanging;
                if (!iframe.method_31481()) {
                    ((ItemFrameAccessor)iframe).invoker$dropItem((class_3218)serverWorld, (class_1297)tickingEntity, true);
                }
                iframe.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, EntityTickContext context) {
        if (!context.applyNotifierIfAvailable(explosionContext::creator)) {
            context.applyOwnerIfAvailable(explosionContext::creator);
        }
        explosionContext.source(context.getSource(Entity.class).orElseThrow(() -> new IllegalStateException("Ticking a non Entity")));
    }

    @Override
    public boolean doesBlockEventTracking(EntityTickContext context) {
        return context.allowsBlockEvents();
    }
}

