/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.block.transaction.Operations;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.FluidTickContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.world.BlockChange;

class FluidTickPhaseState
extends LocationBasedTickPhaseState<FluidTickContext> {
    private final String desc;

    FluidTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Tick", name, this);
    }

    @Override
    public FluidTickContext createNewContext(PhaseTracker tracker) {
        return new FluidTickContext(this, tracker);
    }

    @Override
    public boolean shouldProvideModifiers(FluidTickContext phaseContext) {
        return phaseContext.providesModifier;
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(FluidTickContext phaseContext, class_2680 newState, class_2680 currentState) {
        class_2248 newBlock = newState.method_26204();
        if (phaseContext.tickingBlock.method_15772() instanceof class_3609) {
            if (newBlock == class_2246.field_10124) {
                return BlockChange.BREAK;
            }
            if (currentState.method_26204() instanceof class_2404) {
                if (newBlock instanceof class_2404) {
                    return BlockChange.MODIFY;
                }
                if (newState.method_26215()) {
                    return BlockChange.DECAY;
                }
                return BlockChange.PLACE;
            }
            if (currentState.method_26215() && newBlock instanceof class_2404) {
                return BlockChange.PLACE;
            }
        }
        return super.associateBlockChangeWithSnapshot(phaseContext, newState, currentState);
    }

    @Override
    public Operation getBlockOperation(FluidTickContext phaseContext, SpongeBlockSnapshot original, SpongeBlockSnapshot result) {
        FluidState fluidState = original.state().fluidState();
        if (!fluidState.isEmpty() && result.blockChange == BlockChange.DECAY) {
            return (Operation)Operations.LIQUID_DECAY.get();
        }
        if (fluidState.isEmpty() && result.blockChange == BlockChange.PLACE) {
            return (Operation)Operations.LIQUID_SPREAD.get();
        }
        if (!fluidState.isEmpty() && result.blockChange == BlockChange.MODIFY) {
            return (Operation)Operations.LIQUID_SPREAD.get();
        }
        return super.getBlockOperation(phaseContext, original, result);
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

