/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.util.MemoizedSupplier;
import org.spongepowered.common.world.BlockChange;

abstract class LocationBasedTickPhaseState<T extends LocationBasedTickContext<T>>
extends TickPhaseState<T> {
    private final BiConsumer<CauseStackManager.StackFrame, T> LOCATION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(LocatableBlock.class).ifPresent(arg_0 -> ((CauseStackManager.StackFrame)frame).pushCause(arg_0)));

    LocationBasedTickPhaseState() {
    }

    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, T> getFrameModifier() {
        return this.LOCATION_MODIFIER;
    }

    @Override
    public void unwind(T context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public void associateNeighborStateNotifier(T context, @Nullable class_2338 sourcePos, class_2248 block, class_2338 notifyPos, class_3218 minecraftWorld, PlayerTracker.Type notifier) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            LevelChunkBridge mixinChunk = (LevelChunkBridge)minecraftWorld.method_8500(notifyPos);
            mixinChunk.bridge$addTrackedBlockPosition(block, notifyPos, (UUID)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public boolean doesBlockEventTracking(T context) {
        return ((PhaseContext)context).allowsBlockEvents();
    }

    @Override
    public void appendNotifierToBlockEvent(T context, TrackedWorldBridge mixinWorldServer, class_2338 pos, TrackableBlockEventDataBridge blockEvent) {
        LocatableBlock source = this.getLocatableBlockSourceFromContext((PhaseContext<?>)context);
        blockEvent.bridge$setTickingLocatable(source);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(T context) {
        return MemoizedSupplier.memoize(() -> {
            @NonNull @NonNull World world = this.getLocatableBlockSourceFromContext((PhaseContext<?>)context).world();
            return (ResourceKey)((class_1937)world).method_27983().method_29177();
        });
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, T context) {
        ((PhaseContext)context).applyOwnerIfAvailable(explosionContext::creator);
        ((PhaseContext)context).applyNotifierIfAvailable(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext((PhaseContext<?>)context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public void postBlockTransactionApplication(T context, ServerWorld serverWorld, BlockChange blockChange, BlockTransactionReceipt receipt) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            SpongeBlockSnapshot original = (SpongeBlockSnapshot)receipt.originalBlock();
            class_2248 block = (class_2248)original.state().type();
            class_2338 changedBlockPos = original.getBlockPos();
            original.getServerWorld().ifPresent(worldServer -> {
                LevelChunkBridge changedMixinChunk = (LevelChunkBridge)worldServer.method_8500(changedBlockPos);
                changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)user, PlayerTracker.Type.NOTIFIER);
                if (blockChange == BlockChange.PLACE) {
                    context.applyOwnerIfAvailable(owner -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)owner, PlayerTracker.Type.CREATOR));
                }
            });
        });
    }
}

