/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.fluid.FluidStack;
import org.spongepowered.api.fluid.FluidStackSnapshot;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.fluid.SpongeFluidStackBuilder;
import org.spongepowered.common.fluid.SpongeFluidStackSnapshotBuilder;
import org.spongepowered.common.util.Constants;

public class SpongeFluidStack
implements FluidStack,
SpongeMutableDataHolder {
    private FluidType fluidType;
    private int volume;
    private @Nullable DataContainer extraData;

    SpongeFluidStack(SpongeFluidStackBuilder builder) {
        this.fluidType = builder.fluidType;
        this.volume = builder.volume;
        DataContainer dataContainer = this.extraData = builder.extra == null ? null : builder.extra.copy();
        if (builder.keyValues != null) {
            builder.keyValues.forEach((k, v) -> this.offer((Key)k, v));
        }
    }

    private SpongeFluidStack(FluidType fluidType, int volume, @Nullable DataContainer extraData) {
        this.fluidType = fluidType;
        this.volume = volume;
        this.extraData = extraData == null ? null : extraData.copy();
    }

    public @NonNull FluidType fluid() {
        return this.fluidType;
    }

    public int volume() {
        return this.volume;
    }

    public @NonNull FluidStack setVolume(int volume) {
        if (volume <= 0) {
            throw new IllegalArgumentException("Volume must be at least 0!");
        }
        this.volume = volume;
        return this;
    }

    public @NonNull FluidStackSnapshot createSnapshot() {
        return (FluidStackSnapshot)new SpongeFluidStackSnapshotBuilder().from(this).build();
    }

    public boolean validateRawData(DataView container) {
        return container.contains(Queries.CONTENT_VERSION, new DataQuery[]{Constants.Fluids.FLUID_TYPE, Constants.Fluids.FLUID_VOLUME});
    }

    public void setRawData(@NonNull DataView container) throws InvalidDataException {
        try {
            int contentVersion = (Integer)container.getInt(Queries.CONTENT_VERSION).get();
            if (contentVersion != this.contentVersion()) {
                throw new InvalidDataException("Older content found! Cannot set raw data of older content!");
            }
            String rawFluid = (String)container.getString(Constants.Fluids.FLUID_TYPE).get();
            int volume = (Integer)container.getInt(Constants.Fluids.FLUID_VOLUME).get();
            Optional fluidType = Sponge.game().registry((RegistryType)RegistryTypes.FLUID_TYPE).findValue(ResourceKey.resolve((String)rawFluid));
            if (!fluidType.isPresent()) {
                throw new InvalidDataException("Unknown FluidType found! Requested: " + rawFluid + "but got none.");
            }
            this.fluidType = (FluidType)fluidType.get();
            this.volume = volume;
            if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
                this.extraData = ((DataView)container.getView(Constants.Sponge.UNSAFE_NBT).get()).copy();
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("DataContainer contained invalid data!", (Throwable)e);
        }
    }

    public int contentVersion() {
        return 1;
    }

    public @NonNull DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.game().registry((RegistryType)RegistryTypes.FLUID_TYPE).valueKey((Object)this.fluidType);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Constants.Fluids.FLUID_TYPE, (Object)resourceKey).set(Constants.Fluids.FLUID_VOLUME, (Object)this.volume);
        if (this.extraData != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, (Object)this.extraData);
        }
        return container;
    }

    public FluidStack copy() {
        return new SpongeFluidStack(this.fluidType, this.volume, this.extraData);
    }
}

