/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2259;
import net.minecraft.class_2378;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.fluid.FluidTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;

public final class SpongeFluidStateBuilder
implements FluidState.Builder {
    private FluidState state = (FluidState)((FluidType)FluidTypes.EMPTY.get()).defaultState();

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull FluidState.Builder fluid(@NonNull FluidType fluidType) {
        this.state = (FluidState)Objects.requireNonNull(fluidType).defaultState();
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull FluidState.Builder fromString(@NonNull String id) {
        this.state = this.parseString(id);
        return this;
    }

    public <V> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull FluidState.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
        Objects.requireNonNull(this.state, "The fluid type must be set first");
        Objects.requireNonNull(key, "The key must not be null");
        Objects.requireNonNull(key, "The value must not be null");
        this.state = this.state.with(key, value).orElse(this.state);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull FluidState.Builder from(@NonNull FluidState holder) {
        this.state = holder;
        return this;
    }

    public @NonNull FluidState build() {
        Objects.requireNonNull(this.state, "There must be a FluidType specified.");
        return this.state;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull FluidState.Builder reset() {
        this.state = null;
        return this;
    }

    public @NonNull Optional<FluidState> build(@NonNull DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Fluids.FLUID_STATE)) {
            return Optional.empty();
        }
        DataUtil.checkDataExists(container, Constants.Fluids.FLUID_STATE);
        try {
            return container.getString(Constants.Fluids.FLUID_STATE).map(this::parseString);
        }
        catch (Exception e) {
            throw new InvalidDataException("Could not retrieve a blockstate!", (Throwable)e);
        }
    }

    private FluidState parseString(String string) {
        StringReader reader = new StringReader(string);
        try {
            class_3611 fluid = this.readFluid(reader);
            class_3610 state = reader.canRead() && reader.peek() == '[' ? this.readProperties(reader, fluid) : fluid.method_15785();
            return (FluidState)state;
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("The string " + string + " doe not parse into a valid FluidState", e);
        }
    }

    private class_3611 readFluid(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        class_2960 fluidKey = class_2960.method_12835((StringReader)reader);
        class_2378 fluidRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41270);
        return (class_3611)fluidRegistry.method_17966(fluidKey).orElseThrow(() -> {
            reader.setCursor(cursor);
            return class_2259.field_10690.createWithContext((ImmutableStringReader)reader, (Object)fluidKey.toString());
        });
    }

    private class_3610 readProperties(StringReader reader, class_3611 fluid) throws CommandSyntaxException {
        reader.skip();
        reader.skipWhitespace();
        class_3610 state = fluid.method_15785();
        class_2689 stateContainer = fluid.method_15783();
        while (reader.canRead() && reader.peek() != ']') {
            reader.skipWhitespace();
            int cursor = reader.getCursor();
            String propertyKey = reader.readString();
            class_2769 property = stateContainer.method_11663(propertyKey);
            if (property == null) {
                reader.setCursor(cursor);
                throw class_2259.field_10695.createWithContext((ImmutableStringReader)reader, (Object)fluid.toString(), (Object)propertyKey);
            }
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() == '=') {
                reader.skip();
                reader.skipWhitespace();
                int cursor1 = reader.getCursor();
                state = this.parseValue(state, reader, property, cursor1);
                reader.skipWhitespace();
                if (!reader.canRead()) continue;
                if (reader.peek() == ',') {
                    reader.skip();
                    continue;
                }
                if (reader.peek() == ']') break;
                throw class_2259.field_10684.createWithContext((ImmutableStringReader)reader);
            }
            throw class_2259.field_10688.createWithContext((ImmutableStringReader)reader, (Object)fluid.toString(), (Object)propertyKey);
        }
        if (!reader.canRead()) {
            throw class_2259.field_10684.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        return state;
    }

    private <T extends Comparable<T>> class_3610 parseValue(class_3610 state, StringReader reader, class_2769<T> property, int cursor) throws CommandSyntaxException {
        Optional propertyValue = property.method_11900(reader.readString());
        if (propertyValue.isPresent()) {
            return (class_3610)state.method_11657(property, (Comparable)propertyValue.get());
        }
        reader.setCursor(cursor);
        throw class_2259.field_10683.createWithContext((ImmutableStringReader)reader, (Object)state.method_15772().toString(), (Object)property.method_11899(), (Object)cursor);
    }
}

