/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.PrivateElements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

final class BindingHelper {
    private final Binder binder;
    private final Map<Key<?>, Object> combinedKeys;

    BindingHelper(Binder binder) {
        this.binder = binder;
        this.combinedKeys = new HashMap();
    }

    void bind() {
        for (Map.Entry<Key<?>, Object> key : this.combinedKeys.entrySet()) {
            Object value = key.getValue();
            if (value instanceof Set) {
                Set set = (Set)value;
                value = ImmutableSet.copyOf((Collection)set);
            } else if (value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                value = ImmutableList.copyOf((Iterable)iterable);
            }
            this.binder.bind(key.getKey()).toInstance(value);
        }
    }

    void bindFrom(Injector fromInjector) {
        for (Binding binding : fromInjector.getBindings().values()) {
            ElementSource elementSource;
            Object object = binding.getSource();
            if (!(object instanceof ElementSource) || (elementSource = (ElementSource)object).getDeclaringSource() == BindingHelper.class) continue;
            this.bindFrom(fromInjector, binding);
        }
    }

    void bindFrom(Injector fromInjector, Binding binding) {
        if (binding instanceof ExposedBinding) {
            ExposedBinding exposedBinding = (ExposedBinding)binding;
            PrivateElements privateElements = exposedBinding.getPrivateElements();
            for (Element privateElement : privateElements.getElements()) {
                if (!(privateElement instanceof Binding)) continue;
                Binding privateBinding = (Binding)privateElement;
                if (!privateElements.getExposedKeys().contains(privateBinding.getKey())) continue;
                this.bindFrom(fromInjector, privateBinding);
            }
            return;
        }
        this.bind(fromInjector, binding);
    }

    private void bind(Injector fromInjector, Binding<?> binding) {
        Key key = binding.getKey();
        Class clazz = key.getTypeLiteral().getRawType();
        if (Iterable.class.isAssignableFrom(clazz)) {
            Collection destinationCollection = Set.class.isAssignableFrom(clazz) ? (Collection)this.getBindData(key, () -> new HashSet()) : (Collection)this.getBindData(key, () -> new ArrayList());
            Iterable originalIterable = (Iterable)fromInjector.getInstance(key);
            for (Object value : originalIterable) {
                destinationCollection.add(value);
            }
        } else {
            this.binder.bind(key).toProvider(() -> fromInjector.getInstance(key));
        }
    }

    private <T> T getBindData(Key<T> key, Supplier<T> newValueSupplier) {
        return (T)this.combinedKeys.computeIfAbsent(key, $ -> newValueSupplier.get());
    }
}

