/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject.plugin;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.inject.plugin.PrivatePluginModule;
import org.spongepowered.common.inject.plugin.PublicPluginModule;
import org.spongepowered.plugin.PluginContainer;

public final class PluginGuice {
    public static Injector create(PluginContainer container, Class<?> pluginClass, @Nullable Injector platformInjector) {
        Module module = Modules.combine((Module[])new Module[]{new PrivatePluginModule(container, pluginClass), new PublicPluginModule(container)});
        @Nullable Object customModule = container.metadata().property("guice-module").orElse(null);
        if (customModule != null) {
            try {
                Class<?> moduleClass = Class.forName(customModule.toString(), true, pluginClass.getClassLoader());
                Module moduleInstance = (Module)moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                module = Modules.override((Module[])new Module[]{module}).with(new Module[]{moduleInstance});
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to instantiate the custom module!", ex);
            }
        }
        if (platformInjector != null) {
            return platformInjector.createChildInjector(new Module[]{module});
        }
        return Guice.createInjector((Module[])new Module[]{module});
    }
}

