/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.EmptyInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.ViewableInventory;

public class EmptyInventoryImpl
implements EmptyInventory {
    private final Inventory parent;

    public EmptyInventoryImpl(@Nullable Inventory parent) {
        this.parent = parent == null ? this : parent;
    }

    public List<Slot> slots() {
        return Collections.emptyList();
    }

    public InventoryTransactionResult.Poll poll() {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).poll((ItemStackLike)ItemStackSnapshot.empty()).build();
    }

    public InventoryTransactionResult.Poll poll(int limit) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).poll((ItemStackLike)ItemStackSnapshot.empty()).build();
    }

    public ItemStack peek() {
        return ItemStack.empty();
    }

    public List<Inventory> children() {
        return Collections.emptyList();
    }

    public void clear() {
    }

    public int freeCapacity() {
        return 0;
    }

    public int totalQuantity() {
        return 0;
    }

    public int capacity() {
        return 0;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean contains(ItemStackLike stack) {
        return false;
    }

    public boolean containsAny(ItemStackLike stack) {
        return false;
    }

    public <V> Optional<V> get(Inventory child, Key<? extends Value<V>> key) {
        return Optional.empty();
    }

    public <V> Optional<V> get(Key<? extends Value<V>> key) {
        return Optional.empty();
    }

    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return Optional.empty();
    }

    public boolean supports(Key<?> key) {
        return false;
    }

    public Set<Key<?>> getKeys() {
        return ImmutableSet.of();
    }

    public Set<Value.Immutable<?>> getValues() {
        return ImmutableSet.of();
    }

    public boolean contains(ItemType type) {
        return false;
    }

    public Inventory query(KeyValueMatcher<?> matcher) {
        return this;
    }

    public Inventory query(Query query) {
        return query.execute((Inventory)this);
    }

    public <T extends Inventory> Optional<T> query(Class<T> inventoryType) {
        if (EmptyInventory.class == inventoryType) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public Inventory intersect(Inventory inventory) {
        return this;
    }

    public Inventory union(Inventory inventory) {
        return inventory;
    }

    public boolean containsInventory(Inventory inventory) {
        return this == inventory;
    }

    public Inventory parent() {
        return this.parent;
    }

    public Inventory root() {
        return this.parent == this ? this : this.parent.root();
    }

    public InventoryTransactionResult offer(ItemStackLike ... stacks) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(stacks).build();
    }

    public InventoryTransactionResult.Poll pollFrom(int index) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).poll((ItemStackLike)ItemStackSnapshot.empty()).build();
    }

    public InventoryTransactionResult.Poll pollFrom(int index, int limit) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).poll((ItemStackLike)ItemStackSnapshot.empty()).build();
    }

    public Optional<ItemStack> peekAt(int index) {
        return Optional.empty();
    }

    public InventoryTransactionResult offer(int index, ItemStackLike stack) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).reject(new ItemStackLike[]{stack}).build();
    }

    public InventoryTransactionResult set(int index, ItemStackLike stack) {
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).reject(new ItemStackLike[]{stack}).build();
    }

    public boolean canFit(ItemStackLike stack) {
        return false;
    }

    public Optional<Slot> slot(int index) {
        return Optional.empty();
    }

    public boolean containsChild(Inventory child) {
        return this == child;
    }

    public Optional<ViewableInventory> asViewable() {
        return Optional.empty();
    }
}

