/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.util.Preconditions;

public class InventoryTransactionResultImpl
implements InventoryTransactionResult,
InventoryTransactionResult.Poll {
    private final List<SlotTransaction> slotTransactions;
    private final List<ItemStackSnapshot> rejected;
    private final List<ItemStackSnapshot> polled;
    private final InventoryTransactionResult.Type type;

    InventoryTransactionResultImpl(Builder builder) {
        this.type = Objects.requireNonNull(builder.resultType, "Result type");
        this.rejected = builder.rejected != null ? ImmutableList.copyOf(builder.rejected) : Collections.emptyList();
        this.slotTransactions = builder.slotTransactions != null ? ImmutableList.copyOf(builder.slotTransactions) : Collections.emptyList();
        this.polled = builder.polled != null ? ImmutableList.copyOf(builder.polled) : Collections.emptyList();
    }

    public InventoryTransactionResult and(InventoryTransactionResult other) {
        InventoryTransactionResult.Type resultType = InventoryTransactionResult.Type.SUCCESS;
        if (this.type == InventoryTransactionResult.Type.ERROR || other.type() == InventoryTransactionResult.Type.ERROR) {
            resultType = InventoryTransactionResult.Type.ERROR;
        }
        if (this.type == InventoryTransactionResult.Type.FAILURE || other.type() == InventoryTransactionResult.Type.FAILURE) {
            resultType = InventoryTransactionResult.Type.FAILURE;
        }
        InventoryTransactionResult.Builder builder = InventoryTransactionResult.builder().type(resultType).reject(this.rejected).reject((Iterable)other.rejectedItems()).transaction(this.slotTransactions).transaction((Iterable)other.slotTransactions());
        this.polled.forEach(arg_0 -> ((InventoryTransactionResult.Builder)builder).poll(arg_0));
        return builder.build();
    }

    public void revert() {
        for (SlotTransaction transaction : Lists.reverse(this.slotTransactions)) {
            transaction.slot().set((ItemStackLike)transaction.original());
        }
    }

    public boolean revertOnFailure() {
        if (this.type == InventoryTransactionResult.Type.FAILURE) {
            this.revert();
            return true;
        }
        return false;
    }

    public InventoryTransactionResult.Type type() {
        return this.type;
    }

    public List<ItemStackSnapshot> rejectedItems() {
        return this.rejected;
    }

    public List<SlotTransaction> slotTransactions() {
        return this.slotTransactions;
    }

    public List<ItemStackSnapshot> polledItems() {
        return this.polled;
    }

    public ItemStackSnapshot polledItem() {
        return this.polled.get(0);
    }

    public static class Builder
    implements InventoryTransactionResult.Builder,
    InventoryTransactionResult.Builder.PollBuilder {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable InventoryTransactionResult.Type resultType;
        @Nullable List<ItemStackSnapshot> rejected;
        @Nullable List<SlotTransaction> slotTransactions;
        @Nullable List<ItemStackSnapshot> polled;

        public InventoryTransactionResult.Builder type(InventoryTransactionResult.Type type) {
            this.resultType = Objects.requireNonNull(type, "Type cannot be null!");
            return this;
        }

        public InventoryTransactionResult.Builder.PollBuilder poll(ItemStackLike itemStack) {
            if (this.polled == null) {
                this.polled = new ArrayList<ItemStackSnapshot>();
            }
            this.polled.add(itemStack.asImmutable());
            return this;
        }

        public InventoryTransactionResult.Builder reject(ItemStackLike ... itemStacks) {
            if (this.rejected == null) {
                this.rejected = new ArrayList<ItemStackSnapshot>();
            }
            for (ItemStackLike itemStack1 : itemStacks) {
                if (itemStack1.isEmpty()) continue;
                this.rejected.add(itemStack1.asImmutable());
            }
            return this;
        }

        public InventoryTransactionResult.Builder reject(Iterable<? extends ItemStackLike> itemStacks) {
            if (this.rejected == null) {
                this.rejected = new ArrayList<ItemStackSnapshot>();
            }
            for (ItemStackLike itemStackLike : itemStacks) {
                if (itemStackLike.isEmpty()) continue;
                this.rejected.add(itemStackLike.asImmutable());
            }
            return this;
        }

        public InventoryTransactionResult.Builder transaction(SlotTransaction ... slotTransactions) {
            return this.transaction(Arrays.asList(slotTransactions));
        }

        public InventoryTransactionResult.Builder transaction(Iterable<SlotTransaction> slotTransactions) {
            if (this.slotTransactions == null) {
                this.slotTransactions = new ArrayList<SlotTransaction>();
            }
            for (SlotTransaction transaction : slotTransactions) {
                this.slotTransactions.add(transaction);
            }
            return this;
        }

        public InventoryTransactionResult.Poll build() {
            Preconditions.checkState(this.resultType != null, "ResultType cannot be null!");
            return new InventoryTransactionResultImpl(this);
        }

        public InventoryTransactionResult.Builder from(InventoryTransactionResult value) {
            Objects.requireNonNull(value, "InventoryTransactionResult cannot be null!");
            this.resultType = Objects.requireNonNull(value.type(), "ResultType cannot be null!");
            this.slotTransactions = new ArrayList<SlotTransaction>(value.slotTransactions());
            this.rejected = new ArrayList<ItemStackSnapshot>(value.rejectedItems());
            return this;
        }

        public InventoryTransactionResult.Builder reset() {
            this.resultType = null;
            this.rejected = null;
            this.slotTransactions = null;
            return this;
        }
    }
}

