/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl;

import java.util.Optional;
import net.minecraft.class_1799;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

public abstract class AdapterLogic {
    private AdapterLogic() {
    }

    public static InventoryTransactionResult.Poll pollSequential(Fabric fabric, @Nullable Lens lens, @Nullable Integer limit) {
        if (lens == null || lens.getSlots(fabric).size() <= 0) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).poll((ItemStackLike)ItemStackSnapshot.empty()).build();
        }
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        ItemStack removedType = null;
        int totalPolled = 0;
        for (SlotLens slot : lens.getSlots(fabric)) {
            class_1799 stack = slot.getStack(fabric);
            if (stack.method_7960() || removedType != null && !ItemStackUtil.compareIgnoreQuantity(removedType, stack)) continue;
            int pollCount = limit != null ? Math.min(stack.method_7947(), limit) : stack.method_7947();
            class_1799 newStack = class_1799.field_8037;
            if (pollCount < stack.method_7947()) {
                newStack = stack.method_7972();
                newStack.method_7939(newStack.method_7947() - pollCount);
            }
            if (slot.setStack(fabric, newStack)) {
                SlotAdapter slotAdapter = (SlotAdapter)slot.getAdapter(fabric, null);
                result.transaction(new SlotTransaction[]{new SlotTransaction((Slot)slotAdapter, ItemStackUtil.snapshotOf(stack), ItemStackUtil.snapshotOf(newStack))});
                if (removedType == null) {
                    removedType = ItemStackUtil.cloneDefensive(stack, 1);
                }
                if (limit == null) {
                    totalPolled = pollCount;
                    break;
                }
                limit = limit - pollCount;
                totalPolled += pollCount;
            }
            if (limit == null || limit > 0) continue;
            break;
        }
        if (removedType != null) {
            fabric.fabric$markDirty();
        }
        if (limit != null && limit > 0) {
            result.type(InventoryTransactionResult.Type.FAILURE);
        }
        if (removedType == null) {
            removedType = ItemStack.empty();
        } else {
            removedType.setQuantity(totalPolled);
        }
        return result.poll((ItemStackLike)removedType).build();
    }

    public static Optional<ItemStack> peekSequential(Fabric fabric, @Nullable Lens lens) {
        return AdapterLogic.findStack(fabric, lens);
    }

    private static Optional<ItemStack> findStack(Fabric fabric, @Nullable Lens lens) {
        if (lens == null || lens.getSlots(fabric).size() <= 0) {
            return Optional.empty();
        }
        for (SlotLens slot : lens.getSlots(fabric)) {
            class_1799 stack = slot.getStack(fabric);
            if (stack.method_7960()) continue;
            return ItemStackUtil.cloneDefensiveOptional(stack);
        }
        if (lens.slotCount() > 0) {
            return Optional.of(ItemStack.empty());
        }
        return Optional.of(ItemStack.empty());
    }

    public static InventoryTransactionResult insertSequential(Fabric fabric, @Nullable Lens lens, ItemStack stack) {
        if (lens == null) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(new ItemStackLike[]{ItemStackUtil.cloneDefensive(stack)}).build();
        }
        try {
            return AdapterLogic.insertStack(fabric, lens, stack);
        }
        catch (Exception ex) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.ERROR).reject(new ItemStackLike[]{ItemStackUtil.cloneDefensive(stack)}).build();
        }
    }

    private static InventoryTransactionResult insertStack(Fabric fabric, Lens lens, ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        class_1799 nativeStack = ItemStackUtil.toNative(stack);
        if (stack.isEmpty() && lens.slotCount() == 1) {
            class_1799 old = lens.getStack(fabric, 0);
            ItemStackSnapshot oldSnap = ItemStackUtil.snapshotOf(old);
            lens.setStack(fabric, 0, nativeStack);
            SlotTransaction trans = new SlotTransaction((Slot)lens.getAdapter(fabric, null), oldSnap, ItemStackSnapshot.empty());
            result.transaction(new SlotTransaction[]{trans});
            return result.build();
        }
        int maxStackSize = Math.min(lens.getMaxStackSize(fabric), nativeStack.method_7914());
        int remaining = stack.quantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            class_1799 old = lens.getStack(fabric, ord);
            ItemStackSnapshot oldSnap = ItemStackUtil.snapshotOf(old);
            int push = Math.min(remaining, maxStackSize);
            class_1799 newStack = ItemStackUtil.cloneDefensiveNative(nativeStack, push);
            if (!lens.setStack(fabric, ord, newStack)) continue;
            remaining -= push;
            Slot slot = lens.getSlotLens(fabric, ord).getAdapter(fabric, null);
            SlotTransaction trans = new SlotTransaction(slot, oldSnap, ItemStackUtil.snapshotOf(lens.getStack(fabric, ord)));
            result.transaction(new SlotTransaction[]{trans});
        }
        if (remaining > 0) {
            result.reject(new ItemStackLike[]{ItemStackUtil.cloneDefensive(nativeStack, remaining)});
        }
        fabric.fabric$markDirty();
        return result.build();
    }

    public static InventoryTransactionResult appendSequential(Fabric fabric, @Nullable Lens lens, ItemStack stack) {
        if (lens == null) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).reject(new ItemStackLike[]{ItemStackUtil.cloneDefensive(stack)}).build();
        }
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        class_1799 nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = Math.min(lens.getMaxStackSize(fabric), nativeStack.method_7914());
        int remaining = stack.quantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            class_1799 old = lens.getStack(fabric, ord);
            int push = Math.min(remaining, maxStackSize);
            if (old.method_7960() && lens.setStack(fabric, ord, ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
                remaining -= push;
                SlotAdapter slot = (SlotAdapter)lens.getSlotLens(fabric, ord).getAdapter(fabric, null);
                result.transaction(new SlotTransaction[]{new SlotTransaction((Slot)slot, ItemStackUtil.snapshotOf(old), ItemStackUtil.snapshotOf(lens.getStack(fabric, ord)))});
                continue;
            }
            if (old.method_7960() || !ItemStackUtil.compareIgnoreQuantity(old, stack) || maxStackSize <= old.method_7947()) continue;
            ItemStackSnapshot oldSnap = ItemStackUtil.snapshotOf(old);
            push = Math.max(Math.min(maxStackSize - old.method_7947(), remaining), 0);
            old.method_7939(old.method_7947() + push);
            lens.setStack(fabric, ord, old);
            remaining -= push;
            SlotAdapter slot = (SlotAdapter)lens.getSlotLens(fabric, ord).getAdapter(fabric, null);
            result.transaction(new SlotTransaction[]{new SlotTransaction((Slot)slot, oldSnap, ItemStackUtil.snapshotOf(lens.getStack(fabric, ord)))});
        }
        if (remaining > 0) {
            result.type(InventoryTransactionResult.Type.FAILURE).reject(new ItemStackLike[]{ItemStackUtil.cloneDefensive(nativeStack, remaining)});
        }
        if (remaining != stack.quantity()) {
            fabric.fabric$markDirty();
        }
        return result.build();
    }

    public static int countFreeCapacity(Fabric fabric, Lens lens) {
        return lens.getSlots(fabric).stream().mapToInt(slot -> slot.getStack(fabric).method_7960() ? 1 : 0).sum();
    }

    public static int countQuantity(Fabric fabric, Lens lens) {
        int items = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            class_1799 stack = lens.getStack(fabric, ord);
            items += !stack.method_7960() ? stack.method_7947() : 0;
        }
        return items;
    }

    public static int getCapacity(Fabric fabric, Lens lens) {
        return lens.slotCount();
    }

    public static boolean contains(InventoryAdapter adapter, ItemStack stack) {
        return AdapterLogic.contains(adapter.inventoryAdapter$getFabric(), adapter.inventoryAdapter$getRootLens(), stack, stack.quantity());
    }

    public static boolean contains(InventoryAdapter adapter, ItemStack stack, int quantity) {
        return AdapterLogic.contains(adapter.inventoryAdapter$getFabric(), adapter.inventoryAdapter$getRootLens(), stack, quantity);
    }

    public static boolean contains(Fabric fabric, Lens lens, ItemStack stack, int quantity) {
        class_1799 nonNullStack = ItemStackUtil.toNative(stack);
        int found = 0;
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            class_1799 slotStack = lens.getStack(fabric, ord);
            if (!(slotStack.method_7960() ? nonNullStack.method_7960() && ++found >= quantity : ItemStackUtil.compareIgnoreQuantity(slotStack, stack) && (found += slotStack.method_7947()) >= quantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(InventoryAdapter adapter, ItemType type) {
        return AdapterLogic.contains(adapter.inventoryAdapter$getFabric(), adapter.inventoryAdapter$getRootLens(), type);
    }

    public static boolean contains(Fabric fabric, Lens lens, ItemType type) {
        for (int ord = 0; ord < lens.slotCount(); ++ord) {
            class_1799 slotStack = lens.getStack(fabric, ord);
            if (!(slotStack.method_7960() ? type == null || type == ItemTypes.AIR : slotStack.method_7909() == type)) continue;
            return true;
        }
        return false;
    }

    public static boolean canFit(Fabric fabric, Lens lens, ItemStack stack) {
        class_1799 nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = Math.min(lens.getMaxStackSize(fabric), nativeStack.method_7914());
        int remaining = stack.quantity();
        for (int ord = 0; ord < lens.slotCount() && remaining > 0; ++ord) {
            class_1799 old = lens.getStack(fabric, ord);
            int push = Math.min(remaining, maxStackSize);
            if (old.method_7960()) {
                remaining -= push;
                continue;
            }
            if (!ItemStackUtil.compareIgnoreQuantity(old, stack)) continue;
            push = Math.max(Math.min(maxStackSize - old.method_7947(), remaining), 0);
            remaining -= push;
        }
        return remaining == 0;
    }
}

