/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.api.item.inventory.query.QueryType;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.inventory.adapter.impl.SlotCollection;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.property.InventoryDataHolder;
import org.spongepowered.common.inventory.query.SpongeQueryTypes;

public interface DefaultImplementedAdapterInventory
extends InventoryDataHolder {
    default public Lens impl$getLens() {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getRootLens();
    }

    default public Fabric impl$getFabric() {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getFabric();
    }

    default public Inventory root() {
        return this.parent() == this ? this : this.parent().root();
    }

    default public Inventory parent() {
        return this;
    }

    default public InventoryTransactionResult.Poll poll() {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens(), null);
    }

    default public InventoryTransactionResult.Poll poll(int limit) {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens(), limit);
    }

    default public ItemStack peek() {
        return AdapterLogic.peekSequential(this.impl$getFabric(), this.impl$getLens()).orElse(ItemStack.empty());
    }

    default public InventoryTransactionResult offer(ItemStackLike ... stacks) {
        InventoryTransactionResult result = InventoryTransactionResult.successNoTransactions();
        for (ItemStackLike stack : stacks) {
            result = result.and(AdapterLogic.appendSequential(this.impl$getFabric(), this.impl$getLens(), stack.asMutable()));
        }
        return result;
    }

    default public boolean canFit(ItemStackLike stack) {
        return AdapterLogic.canFit(this.impl$getFabric(), this.impl$getLens(), stack.asMutable());
    }

    default public int freeCapacity() {
        return AdapterLogic.countFreeCapacity(this.impl$getFabric(), this.impl$getLens());
    }

    default public int totalQuantity() {
        return AdapterLogic.countQuantity(this.impl$getFabric(), this.impl$getLens());
    }

    default public int capacity() {
        return AdapterLogic.getCapacity(this.impl$getFabric(), this.impl$getLens());
    }

    default public boolean hasChildren() {
        return this.impl$getLens().getChildren().size() != 0;
    }

    default public boolean contains(ItemStackLike stack) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack.asMutable());
    }

    default public boolean containsAny(ItemStackLike stack) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), stack.asMutable(), 1);
    }

    default public boolean contains(ItemType type) {
        return AdapterLogic.contains(((InventoryBridge)((Object)this)).bridge$getAdapter(), type);
    }

    default public List<Inventory> children() {
        return this.impl$generateChildren();
    }

    default public List<Inventory> impl$generateChildren() {
        return this.impl$getLens().getSpanningChildren().stream().map(l -> l.getAdapter(this.impl$getFabric(), this)).map(Inventory.class::cast).collect(Collectors.toList());
    }

    default public <T extends Inventory> Optional<T> query(Class<T> inventoryType) {
        Inventory result = this.query(((QueryType.OneParam)QueryTypes.INVENTORY_TYPE.get()).of(inventoryType));
        if (inventoryType.isAssignableFrom(result.getClass())) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    default public Inventory intersect(Inventory inventory) {
        return ((QueryType.OneParam)SpongeQueryTypes.SLOT_LENS.get()).of((Object)ImmutableSet.of((Object)inventory)).execute((Inventory)this);
    }

    default public Inventory union(Inventory inventory) {
        return this.query(((QueryType.OneParam)SpongeQueryTypes.UNION.get()).of((Object)inventory));
    }

    default public boolean containsInventory(Inventory inventory) {
        Inventory result = ((QueryType.OneParam)SpongeQueryTypes.LENS.get()).of((Object)((InventoryBridge)inventory).bridge$getAdapter().inventoryAdapter$getRootLens()).execute((Inventory)this);
        return result.capacity() == inventory.capacity() && ((InventoryAdapter)result).inventoryAdapter$getRootLens() == ((InventoryAdapter)inventory).inventoryAdapter$getRootLens();
    }

    default public boolean containsChild(Inventory child) {
        return this.impl$getLens().getSpanningChildren().contains(((InventoryBridge)child).bridge$getAdapter().inventoryAdapter$getRootLens());
    }

    default public Optional<Slot> slot(int index) {
        return ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getSlot(index);
    }

    default public InventoryTransactionResult.Poll pollFrom(int index) {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), null);
    }

    default public InventoryTransactionResult.Poll pollFrom(int index, int limit) {
        return AdapterLogic.pollSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), limit);
    }

    default public Optional<ItemStack> peekAt(int index) {
        return AdapterLogic.peekSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index));
    }

    default public InventoryTransactionResult set(int index, ItemStackLike stack) {
        return AdapterLogic.insertSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), stack.asMutable());
    }

    default public InventoryTransactionResult offer(int index, ItemStackLike stack) {
        return AdapterLogic.appendSequential(this.impl$getFabric(), this.impl$getLens().getSlotLens(this.impl$getFabric(), index), stack.asMutable());
    }

    default public Optional<ViewableInventory> asViewable() {
        if (this instanceof ViewableInventory) {
            return Optional.of((ViewableInventory)this);
        }
        return Optional.empty();
    }

    default public Inventory query(Query query) {
        return query.execute((Inventory)this);
    }

    default public List<Slot> slots() {
        return SlotCollection.of(this, ((InventoryBridge)((Object)this)).bridge$getAdapter()).slots();
    }

    public static interface WithClear
    extends DefaultImplementedAdapterInventory {
        default public void clear() {
            ((InventoryBridge)((Object)this)).bridge$getAdapter().inventoryAdapter$getFabric().fabric$clear();
        }
    }
}

