/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.comp;

import java.util.Optional;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.GridInventory;
import org.spongepowered.api.item.inventory.type.InventoryColumn;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.common.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.comp.Inventory2DAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.InventoryColumnLens;
import org.spongepowered.common.inventory.lens.impl.comp.InventoryRowLens;
import org.spongepowered.math.vector.Vector2i;

public class GridInventoryAdapter
extends Inventory2DAdapter
implements GridInventory {
    protected final GridInventoryLens gridLens;

    public GridInventoryAdapter(Fabric fabric, GridInventoryLens root) {
        this(fabric, root, null);
    }

    public GridInventoryAdapter(Fabric fabric, GridInventoryLens root, Inventory parent) {
        super(fabric, root, parent);
        this.gridLens = root;
    }

    public int columns() {
        return this.lens2d.getWidth();
    }

    public int rows() {
        return this.lens2d.getHeight();
    }

    public Vector2i dimensions() {
        return new Vector2i(this.columns(), this.rows());
    }

    public Optional<Slot> slot(int x, int y) {
        return BasicInventoryAdapter.forSlot(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), this);
    }

    public Optional<InventoryRow> row(int y) {
        try {
            InventoryRowLens rowLens = this.gridLens.getRow(y);
            return Optional.ofNullable((InventoryRow)rowLens.getAdapter(this.inventoryAdapter$getFabric(), this));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    public Optional<InventoryColumn> column(int x) {
        try {
            InventoryColumnLens columnLens = this.gridLens.getColumn(x);
            return Optional.ofNullable((InventoryColumn)columnLens.getAdapter(this.inventoryAdapter$getFabric(), this));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    public InventoryTransactionResult.Poll poll(int x, int y) {
        return AdapterLogic.pollSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), null);
    }

    public InventoryTransactionResult.Poll poll(int x, int y, int limit) {
        return AdapterLogic.pollSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), limit);
    }

    public Optional<ItemStack> peek(int x, int y) {
        return AdapterLogic.peekSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y));
    }

    public InventoryTransactionResult set(int x, int y, ItemStackLike stack) {
        return AdapterLogic.insertSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), stack.asMutable());
    }
}

