/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.slots;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SlotAdapter
extends BasicInventoryAdapter
implements Slot {
    private final int ordinal;
    private final ImmutableList<Slot> slots;
    private final SlotLens slot;

    public SlotAdapter(Fabric fabric, SlotLens lens, Inventory parent) {
        super(fabric, lens, parent);
        this.slot = lens;
        this.ordinal = lens.getOrdinal(fabric);
        this.slots = ImmutableList.of((Object)this);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public List<Slot> slots() {
        return this.slots;
    }

    @Override
    public InventoryTransactionResult.Poll poll() {
        class_1799 stack = this.inventoryAdapter$getFabric().fabric$getStack(this.ordinal);
        if (stack.method_7960()) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).poll((ItemStackLike)ItemStackSnapshot.empty()).build();
        }
        this.inventoryAdapter$getFabric().fabric$setStack(this.ordinal, class_1799.field_8037);
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS).transaction(new SlotTransaction[]{new SlotTransaction((Slot)this, ItemStackUtil.snapshotOf(stack), ItemStackSnapshot.empty())}).poll((ItemStackLike)ItemStackUtil.snapshotOf(stack)).build();
    }

    @Override
    public ItemStack peek() {
        class_1799 stack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return ItemStackUtil.cloneDefensive(stack);
    }

    @Override
    public InventoryTransactionResult offer(ItemStackLike ... stacks) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        for (ItemStackLike stack : stacks) {
            ItemStackSnapshot oldStack;
            class_1799 nativeStack = ItemStackUtil.fromLikeToNative(stack);
            int maxStackSize = this.slot.getMaxStackSize(this.inventoryAdapter$getFabric());
            int remaining = stack.quantity();
            class_1799 old = this.slot.getStack(this.inventoryAdapter$getFabric());
            ItemStackSnapshot newStack = oldStack = ItemStackUtil.snapshotOf(old);
            int push = Math.min(remaining, maxStackSize);
            if (old.method_7960() && this.slot.setStack(this.inventoryAdapter$getFabric(), ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
                remaining -= push;
                newStack = ItemStackUtil.snapshotOf(stack);
            } else if (!old.method_7960() && ItemStackUtil.compareIgnoreQuantity(old, nativeStack) && maxStackSize > old.method_7947()) {
                this.inventoryAdapter$getFabric().fabric$markDirty();
                push = Math.max(Math.min(maxStackSize - old.method_7947(), remaining), 0);
                old.method_7939(old.method_7947() + push);
                remaining -= push;
                newStack = ItemStackUtil.snapshotOf(old);
            }
            result.transaction(new SlotTransaction[]{new SlotTransaction((Slot)this, oldStack, newStack)});
            if (remaining <= 0) continue;
            result.reject(new ItemStackLike[]{ItemStackUtil.cloneDefensive(nativeStack, remaining)});
            result.type(InventoryTransactionResult.Type.FAILURE);
        }
        return result.build();
    }

    @Override
    public boolean canFit(ItemStackLike stack) {
        if (stack.isEmpty()) {
            return true;
        }
        int maxStackSize = this.inventoryAdapter$getFabric().fabric$getMaxStackSize();
        class_1799 old = this.slot.getStack(this.inventoryAdapter$getFabric());
        if (old.method_7960()) {
            return maxStackSize >= stack.quantity();
        }
        return ItemStackUtil.compareIgnoreQuantity(old, stack.asMutable()) && maxStackSize - old.method_7947() >= stack.quantity();
    }

    public InventoryTransactionResult set(ItemStackLike stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        class_1799 nativeStack = ItemStackUtil.fromLikeToNative(stack);
        class_1799 old = this.slot.getStack(this.inventoryAdapter$getFabric());
        ItemStackSnapshot oldSnap = ItemStackUtil.snapshotOf(old);
        if (stack.isEmpty()) {
            this.clear();
            SlotTransaction trans = new SlotTransaction((Slot)this, oldSnap, ItemStackSnapshot.empty());
            return result.transaction(new SlotTransaction[]{trans}).build();
        }
        int remaining = stack.quantity();
        int push = Math.min(remaining, this.slot.getMaxStackSize(this.inventoryAdapter$getFabric()));
        class_1799 newStack = ItemStackUtil.cloneDefensiveNative(nativeStack, push);
        if (this.slot.setStack(this.inventoryAdapter$getFabric(), newStack)) {
            result.transaction(new SlotTransaction[]{new SlotTransaction((Slot)this, oldSnap, ItemStackUtil.snapshotOf(newStack))});
            remaining -= push;
        }
        if (remaining > 0) {
            result.reject(new ItemStackLike[]{ItemStackUtil.cloneDefensive(nativeStack, remaining)});
        }
        return result.build();
    }

    @Override
    public void clear() {
        this.slot.setStack(this.inventoryAdapter$getFabric(), class_1799.field_8037);
    }

    @Override
    public int freeCapacity() {
        return this.slot.getStack(this.inventoryAdapter$getFabric()).method_7960() ? 1 : 0;
    }

    @Override
    public int totalQuantity() {
        return this.slot.getStack(this.inventoryAdapter$getFabric()).method_7947();
    }

    @Override
    public int capacity() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean contains(ItemStackLike stack) {
        class_1799 slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.method_7960() ? ItemStackUtil.fromLikeToNative(stack).method_7960() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack.asMutable()) && slotStack.method_7947() >= stack.quantity();
    }

    @Override
    public boolean containsAny(ItemStackLike stack) {
        class_1799 slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.method_7960() ? ItemStackUtil.fromLikeToNative(stack).method_7960() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack.asMutable());
    }

    @Override
    public boolean contains(ItemType type) {
        class_1799 slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.method_7960() ? type == null || type == ItemTypes.AIR : slotStack.method_7909().equals(type);
    }

    public Slot viewedSlot() {
        Fabric fabric = this.inventoryAdapter$getFabric();
        if (fabric instanceof class_1735) {
            return (Slot)fabric;
        }
        if (fabric instanceof class_1703) {
            return (Slot)((class_1703)fabric).method_7611(this.ordinal);
        }
        return this;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SlotAdapter.class.getSimpleName() + "[", "]").add("ordinal=" + this.ordinal).toString();
    }
}

