/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.bridge.world.inventory.CarriedBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.plugin.PluginContainer;

public class CustomInventory
implements class_1263,
CarriedBridge {
    private SlotLensProvider slotLensProvider;
    private Lens lens;
    private final PluginContainer plugin;
    private final @Nullable UUID identity;
    private final List<Inventory> inventories;
    private int size;
    private Carrier carrier;

    public CustomInventory(PluginContainer plugin, int size, Lens lens, SlotLensProvider provider, List<Inventory> inventories, @Nullable UUID identity, @Nullable Carrier carrier) {
        this.plugin = plugin;
        this.size = size;
        this.identity = identity;
        this.carrier = carrier;
        this.lens = lens;
        this.slotLensProvider = provider;
        this.inventories = inventories;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    @Override
    public Optional<Carrier> bridge$getCarrier() {
        return Optional.ofNullable(this.carrier);
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }

    public @Nullable UUID getIdentity() {
        return this.identity;
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (Inventory inv : this.inventories) {
            if (inv.totalQuantity() <= 0) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() > index - offset) {
                return inv.slot(index - offset).map(InventoryAdapter.class::cast).map(slot -> slot.inventoryAdapter$getRootLens().getStack(slot.inventoryAdapter$getFabric(), 0)).orElse(class_1799.field_8037);
            }
            offset += inv.capacity();
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int index, int count) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() <= index - offset) {
                offset += inv.capacity();
                continue;
            }
            InventoryTransactionResult.Poll result = inv.pollFrom(index - offset, count);
            return ItemStackUtil.fromSnapshotToNative(result.polledItem());
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int index) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() > index - offset) {
                InventoryTransactionResult.Poll result = inv.pollFrom(index - offset);
                return ItemStackUtil.fromSnapshotToNative(result.polledItem());
            }
            offset += inv.capacity();
        }
        return class_1799.field_8037;
    }

    public void method_5447(int index, class_1799 stack) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() > index - offset) {
                inv.set(index - offset, (ItemStackLike)ItemStackUtil.fromNative(stack));
                return;
            }
            offset += inv.capacity();
        }
    }

    public void method_5431() {
        for (Inventory inventory : this.inventories) {
            if (!(inventory instanceof class_1263)) continue;
            ((class_1263)inventory).method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        for (Inventory inventory : this.inventories) {
            inventory.clear();
        }
    }
}

