/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_3244;
import net.minecraft.class_3944;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.menu.ClickType;
import org.spongepowered.api.item.inventory.menu.ClickTypes;
import org.spongepowered.api.item.inventory.menu.InventoryMenu;
import org.spongepowered.api.item.inventory.menu.handler.ClickHandler;
import org.spongepowered.api.item.inventory.menu.handler.CloseHandler;
import org.spongepowered.api.item.inventory.menu.handler.InventoryCallbackHandler;
import org.spongepowered.api.item.inventory.menu.handler.KeySwapHandler;
import org.spongepowered.api.item.inventory.menu.handler.SlotChangeHandler;
import org.spongepowered.api.item.inventory.menu.handler.SlotClickHandler;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.common.accessor.world.inventory.AbstractContainerMenuAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.custom.ViewableCustomInventory;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeInventoryMenu
implements InventoryMenu {
    private ViewableInventory inventory;
    private Map<Container, ServerPlayer> tracked = new HashMap<Container, ServerPlayer>();
    private Component title;
    private @Nullable SlotClickHandler slotClickHandler;
    private @Nullable ClickHandler clickHandler;
    private @Nullable KeySwapHandler keySwapHandler;
    private @Nullable SlotChangeHandler changeHandler;
    private @Nullable CloseHandler closeHandler;
    private boolean readonly;
    private final HashMap<Integer, Boolean> slotReadOnly = new HashMap();

    public SpongeInventoryMenu(ViewableInventory inventory) {
        this.inventory = inventory;
    }

    public ViewableInventory inventory() {
        return this.inventory;
    }

    public void setCurrentInventory(ViewableInventory inventory) {
        this.slotReadOnly.clear();
        if (inventory.getClass().equals(this.inventory.getClass()) && inventory instanceof ViewableCustomInventory && inventory.capacity() == this.inventory.capacity()) {
            this.inventory = inventory;
            for (Map.Entry<Container, ServerPlayer> entry : this.tracked.entrySet()) {
                class_1703 container = (class_1703)entry.getKey();
                ServerPlayer player = entry.getValue();
                class_1703 newContainer = ((ViewableCustomInventory)inventory).createMenu(-1, ((class_1657)player).method_31548(), (class_1657)player);
                for (int i = 0; i < inventory.capacity(); ++i) {
                    class_1735 slot = (class_1735)newContainer.field_7761.get(i);
                    container.field_7761.set(i, (Object)slot);
                    ((AbstractContainerMenuAccessor)container).accessor$lastSlots().set(i, (Object)slot.method_7677());
                    for (class_1712 listener : ((AbstractContainerMenuAccessor)container).accessor$containerListeners()) {
                        listener.method_7635(container, i, slot.method_7677());
                    }
                }
            }
        } else {
            this.inventory = inventory;
            this.reopen();
        }
    }

    private void reopen() {
        new ArrayList<ServerPlayer>(this.tracked.values()).stream().distinct().forEach(this::open);
    }

    public void setTitle(Component title) {
        this.title = title;
        this.tracked.forEach((c, p) -> {
            class_1703 container = (class_1703)c;
            class_3244 connection = (class_3244)p.connection();
            class_3944 packet = new class_3944(container.field_7763, container.method_17358(), SpongeAdventure.asVanilla(this.title));
            connection.method_14364((class_2596)packet);
            container.method_37420();
        });
    }

    public Optional<Component> title() {
        return Optional.ofNullable(this.title);
    }

    public InventoryMenu setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
        return this;
    }

    public InventoryMenu setReadOnly(Slot slot, boolean readOnly) {
        if (!this.inventory.containsInventory((Inventory)slot)) {
            throw new IllegalArgumentException();
        }
        this.slotReadOnly.put(((SlotAdapter)slot).getOrdinal(), readOnly);
        return this;
    }

    public void registerHandler(InventoryCallbackHandler handler) {
        if (handler instanceof ClickHandler) {
            this.registerClick((ClickHandler)handler);
        }
        if (handler instanceof SlotClickHandler) {
            this.registerSlotClick((SlotClickHandler)handler);
        }
        if (handler instanceof KeySwapHandler) {
            this.registerKeySwap((KeySwapHandler)handler);
        }
        if (handler instanceof CloseHandler) {
            this.registerClose((CloseHandler)handler);
        }
        if (handler instanceof SlotChangeHandler) {
            this.registerChange((SlotChangeHandler)handler);
        }
    }

    public boolean isReadOnly(int slot) {
        return this.slotReadOnly.getOrDefault(slot, this.readonly);
    }

    public void registerClose(CloseHandler handler) {
        this.closeHandler = handler;
    }

    public void registerClick(ClickHandler handler) {
        this.clickHandler = handler;
    }

    public void registerSlotClick(SlotClickHandler handler) {
        this.slotClickHandler = handler;
    }

    public void registerKeySwap(KeySwapHandler handler) {
        this.keySwapHandler = handler;
    }

    public void registerChange(SlotChangeHandler handler) {
        this.changeHandler = handler;
    }

    public void unregisterAll() {
        this.clickHandler = null;
        this.slotClickHandler = null;
        this.keySwapHandler = null;
        this.changeHandler = null;
        this.closeHandler = null;
    }

    public Optional<Container> open(ServerPlayer player) {
        Optional container = player.openInventory((Inventory)this.inventory, this.title);
        container.ifPresent(c -> {
            ((MenuBridge)c).bridge$setMenu(this);
            this.tracked.put((Container)c, player);
        });
        return container;
    }

    public void onClose(class_1657 player, Container container) {
        if (this.closeHandler != null) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
                frame.pushCause((Object)player);
                Cause cause = frame.currentCause();
                this.closeHandler.handle(cause, container);
            }
        }
        this.tracked.remove(container);
    }

    public boolean onClick(int slotId, int dragType, class_1713 clickTypeIn, class_1657 player, Container container) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)player);
            Cause cause = frame.currentCause();
            if (clickTypeIn == class_1713.field_7789) {
                boolean bl = this.onClickDrag(cause, slotId, dragType, container);
                return bl;
            }
            Optional slot = container.slot(slotId);
            if (slot.isPresent()) {
                switch (clickTypeIn) {
                    case field_7791: {
                        if ((dragType < 0 || dragType >= 9) && dragType != 40) break;
                        Optional slot2 = ((Player)player).inventory().slot(dragType);
                        if (slot2.isPresent() && this.keySwapHandler != null) {
                            boolean bl = this.keySwapHandler.handle(cause, container, (Slot)slot.get(), slotId, (ClickType)ClickTypes.KEY_SWAP.get(), (Slot)slot2.get());
                            return bl;
                        }
                        break;
                    }
                    case field_7796: {
                        if (this.slotClickHandler == null) break;
                        boolean bl = this.slotClickHandler.handle(cause, container, (Slot)slot.get(), slotId, (ClickType)ClickTypes.CLICK_MIDDLE.get());
                        return bl;
                    }
                    case field_7793: {
                        if (this.slotClickHandler == null) break;
                        boolean bl = this.slotClickHandler.handle(cause, container, (Slot)slot.get(), slotId, (ClickType)ClickTypes.DOUBLE_CLICK.get());
                        return bl;
                    }
                    default: {
                        if (this.slotClickHandler == null) break;
                        if (dragType == 0) {
                            boolean bl = this.onClickLeft(cause, this.slotClickHandler, clickTypeIn, container, slotId, (Slot)slot.get());
                            return bl;
                        }
                        if (dragType != 1) break;
                        boolean bl = this.onClickRight(cause, this.slotClickHandler, clickTypeIn, container, slotId, (Slot)slot.get());
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            switch (clickTypeIn) {
                case field_7790: {
                    if (slotId != -999 || this.clickHandler == null) break;
                    if (dragType == 0) {
                        boolean bl = this.clickHandler.handle(cause, container, (ClickType)ClickTypes.CLICK_LEFT_OUTSIDE.get());
                        return bl;
                    }
                    if (dragType != 1) break;
                    boolean bl = this.clickHandler.handle(cause, container, (ClickType)ClickTypes.CLICK_RIGHT_OUTSIDE.get());
                    return bl;
                }
                case field_7795: {
                    if (slotId != -999) break;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean onClickDrag(Cause cause, int slotId, int dragType, Container container) {
        int dragMode = dragType >> 2 & 3;
        int dragEvent = dragType & 3;
        switch (dragEvent) {
            case 0: {
                if (this.clickHandler == null) break;
                return this.clickHandler.handle(cause, container, (ClickType)ClickTypes.DRAG_START.get());
            }
            case 1: {
                Optional slot = container.slot(slotId);
                if (!slot.isPresent() || this.slotClickHandler == null) break;
                switch (dragMode) {
                    case 0: {
                        return this.slotClickHandler.handle(cause, container, (Slot)slot.get(), slotId, (ClickType)ClickTypes.DRAG_LEFT_ADD.get());
                    }
                    case 1: {
                        return this.slotClickHandler.handle(cause, container, (Slot)slot.get(), slotId, (ClickType)ClickTypes.DRAG_RIGHT_ADD.get());
                    }
                    case 2: {
                        return this.slotClickHandler.handle(cause, container, (Slot)slot.get(), slotId, (ClickType)ClickTypes.DRAG_MIDDLE_ADD.get());
                    }
                }
                break;
            }
            case 2: {
                if (this.clickHandler == null) break;
                return this.clickHandler.handle(cause, container, (ClickType)ClickTypes.DRAG_END.get());
            }
        }
        return true;
    }

    private boolean onClickRight(Cause cause, SlotClickHandler handler, class_1713 clickTypeIn, Container container, int idx, Slot slot) {
        switch (clickTypeIn) {
            case field_7790: {
                return handler.handle(cause, container, slot, idx, (ClickType)ClickTypes.CLICK_RIGHT.get());
            }
            case field_7794: {
                return handler.handle(cause, container, slot, idx, (ClickType)ClickTypes.SHIFT_CLICK_RIGHT.get());
            }
            case field_7795: {
                return handler.handle(cause, container, slot, idx, (ClickType)ClickTypes.KEY_THROW_ALL.get());
            }
        }
        return true;
    }

    private Boolean onClickLeft(Cause cause, SlotClickHandler handler, class_1713 clickTypeIn, Container container, int idx, Slot slot) {
        switch (clickTypeIn) {
            case field_7790: {
                return handler.handle(cause, container, slot, idx, (ClickType)ClickTypes.CLICK_LEFT.get());
            }
            case field_7794: {
                return handler.handle(cause, container, slot, idx, (ClickType)ClickTypes.SHIFT_CLICK_LEFT.get());
            }
            case field_7795: {
                return handler.handle(cause, container, slot, idx, (ClickType)ClickTypes.KEY_THROW_ONE.get());
            }
        }
        return true;
    }

    public boolean onChange(class_1799 newStack, class_1799 oldStack, Container container, int slotIndex, class_1735 slot) {
        if (this.changeHandler != null) {
            Cause cause = PhaseTracker.getInstance().currentCause();
            return this.changeHandler.handle(cause, container, (Slot)slot, slotIndex, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack));
        }
        return !this.isReadOnly(slotIndex) || slot.field_7871 instanceof PlayerInventory;
    }
}

