/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.fabric;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;

public class CompoundFabric
implements Fabric {
    private final List<Fabric> fabrics;

    public CompoundFabric(Fabric ... fabrics) {
        this.fabrics = Arrays.asList(fabrics);
    }

    public CompoundFabric(List<Inventory> children) {
        this.fabrics = children.stream().map(InventoryBridge.class::cast).map(InventoryBridge::bridge$getAdapter).map(InventoryAdapter::inventoryAdapter$getFabric).collect(Collectors.toList());
    }

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        HashSet<InventoryBridge> inv = new HashSet<InventoryBridge>();
        this.fabrics.forEach(fabric -> inv.addAll(fabric.fabric$allInventories()));
        return inv;
    }

    private <T> T getOnFabric(int index, BiFunction<Integer, Fabric, T> biFunction) {
        int offset = 0;
        for (Fabric fabric : this.fabrics) {
            if (index - offset < fabric.fabric$getSize()) {
                return biFunction.apply(index - offset, fabric);
            }
            offset += fabric.fabric$getSize();
        }
        return null;
    }

    private void runOnFabric(int index, BiConsumer<Integer, Fabric> biConsumer) {
        int offset = 0;
        for (Fabric fabric : this.fabrics) {
            if (index - offset < fabric.fabric$getSize()) {
                biConsumer.accept(index - offset, fabric);
                return;
            }
            offset += fabric.fabric$getSize();
        }
    }

    private <T> T collectOnFabric(BiFunction<Fabric, T, T> biFunction, T initial) {
        T value = initial;
        for (Fabric fabric : this.fabrics) {
            value = biFunction.apply(fabric, (Fabric)value);
        }
        return value;
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        return this.getOnFabric(index, (idx, fabric) -> fabric.fabric$get((int)idx));
    }

    @Override
    public class_1799 fabric$getStack(int index) {
        return this.getOnFabric(index, (idx, fabric) -> fabric.fabric$getStack((int)idx));
    }

    @Override
    public void fabric$setStack(int index, class_1799 stack) {
        this.runOnFabric(index, (idx, fabric) -> fabric.fabric$setStack((int)idx, stack));
    }

    @Override
    public int fabric$getMaxStackSize() {
        return this.collectOnFabric((fabric, value) -> Math.max(value, fabric.fabric$getMaxStackSize()), 0);
    }

    @Override
    public int fabric$getSize() {
        return this.collectOnFabric((fabric, value) -> value + fabric.fabric$getSize(), 0);
    }

    @Override
    public void fabric$clear() {
        this.runOnFabric(0, (i, fabric) -> fabric.fabric$clear());
    }

    @Override
    public void fabric$markDirty() {
        this.runOnFabric(0, (i, fabric) -> fabric.fabric$markDirty());
    }
}

