/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.minecraft;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1703;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.impl.comp.ArmorInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.PrimaryPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.HeldHandSlotLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class PlayerInventoryLens
extends AbstractLens {
    private static final int ARMOR = 4;
    private static final int OFFHAND = 1;
    private PrimaryPlayerInventoryLens primary;
    private EquipmentInventoryLens equipment;
    private ArmorInventoryLens armor;
    private SlotLens offhand;
    private final boolean isContainer;

    public PlayerInventoryLens(int size, Class<? extends Inventory> adapter, SlotLensProvider slots) {
        super(0, size, adapter);
        this.isContainer = false;
        this.init(slots);
    }

    public PlayerInventoryLens(int base, int size, SlotLensProvider slots) {
        super(base, size, PlayerInventory.class);
        this.isContainer = true;
        this.init(slots);
    }

    protected void init(SlotLensProvider slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlotLens(slot), KeyValuePair.slotIndex(ord));
            ++ord;
            ++slot;
        }
        int base = this.base;
        LinkedHashMap<EquipmentType, SlotLens> equipmentLenses = new LinkedHashMap<EquipmentType, SlotLens>();
        if (this.isContainer) {
            this.armor = new ArmorInventoryLens(base, slots, true);
            equipmentLenses.put((EquipmentType)EquipmentTypes.HEAD.get(), slots.getSlotLens(base + 0));
            equipmentLenses.put((EquipmentType)EquipmentTypes.CHEST.get(), slots.getSlotLens(base + 1));
            equipmentLenses.put((EquipmentType)EquipmentTypes.LEGS.get(), slots.getSlotLens(base + 2));
            equipmentLenses.put((EquipmentType)EquipmentTypes.FEET.get(), slots.getSlotLens(base + 3));
            this.primary = new PrimaryPlayerInventoryLens(base += 4, slots, true);
            this.offhand = slots.getSlotLens(base += this.primary.slotCount());
            ++base;
            equipmentLenses.put((EquipmentType)EquipmentTypes.OFFHAND.get(), this.offhand);
            this.addSpanningChild(this.armor, new KeyValuePair[0]);
            this.addSpanningChild(this.primary, new KeyValuePair[0]);
            this.addSpanningChild(this.offhand, new KeyValuePair[0]);
        } else {
            this.primary = new PrimaryPlayerInventoryLens(base, slots, false);
            this.armor = new ArmorInventoryLens(base += this.primary.slotCount(), slots, false);
            equipmentLenses.put((EquipmentType)EquipmentTypes.FEET.get(), slots.getSlotLens(base + 0));
            equipmentLenses.put((EquipmentType)EquipmentTypes.LEGS.get(), slots.getSlotLens(base + 1));
            equipmentLenses.put((EquipmentType)EquipmentTypes.CHEST.get(), slots.getSlotLens(base + 2));
            equipmentLenses.put((EquipmentType)EquipmentTypes.HEAD.get(), slots.getSlotLens(base + 3));
            this.offhand = slots.getSlotLens(base += 4);
            ++base;
            equipmentLenses.put((EquipmentType)EquipmentTypes.OFFHAND.get(), this.offhand);
            this.addSpanningChild(this.primary, new KeyValuePair[0]);
            this.addSpanningChild(this.armor, new KeyValuePair[0]);
            this.addSpanningChild(this.offhand, new KeyValuePair[0]);
        }
        equipmentLenses.put((EquipmentType)EquipmentTypes.MAINHAND.get(), new HeldHandSlotLens(this.primary.getHotbar()));
        this.equipment = new EquipmentInventoryLens(equipmentLenses);
        for (Map.Entry entry : equipmentLenses.entrySet()) {
            this.addChild((Lens)entry.getValue(), KeyValuePair.of(Keys.EQUIPMENT_TYPE, (EquipmentType)entry.getKey()));
        }
        this.addChild(this.equipment, new KeyValuePair[0]);
        this.addMissingSpanningSlots(base, slots);
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        class_1703 container;
        Optional carrier;
        if (this.isContainer && fabric instanceof class_1703 && (carrier = ((CarriedInventory)(container = (class_1703)fabric)).carrier()).isPresent() && carrier.get() instanceof Player) {
            return ((Player)carrier.get()).inventory();
        }
        return (Inventory)fabric.fabric$get(this.base).bridge$getAdapter();
    }

    public PrimaryPlayerInventoryLens getPrimaryInventoryLens() {
        return this.primary;
    }

    public EquipmentInventoryLens getEquipmentLens() {
        return this.equipment;
    }

    public SlotLens getOffhandLens() {
        return this.offhand;
    }

    public ArmorInventoryLens getArmorLens() {
        return this.armor;
    }
}

