/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.slot;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.EquipmentSlotAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.HeldSlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.InvalidOrdinalException;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.impl.comp.HotbarLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

public class HeldHandSlotLens
extends AbstractLens
implements SlotLens {
    private HotbarLens hotbarLens;

    public HeldHandSlotLens(HotbarLens hotbarLens) {
        super(0, 1, BasicInventoryAdapter.class);
        this.hotbarLens = hotbarLens;
    }

    private class_1661 getInventoryPlayer(Fabric fabric) {
        return fabric.fabric$allInventories().stream().filter(inv -> inv instanceof class_1661).map(class_1661.class::cast).findFirst().get();
    }

    @Override
    public class_1799 getStack(Fabric fabric) {
        class_1661 inv = this.getInventoryPlayer(fabric);
        return inv.method_7391();
    }

    @Override
    public boolean setStack(Fabric fabric, class_1799 stack) {
        class_1661 inv = this.getInventoryPlayer(fabric);
        inv.field_7547.set(inv.field_7545, (Object)stack);
        return true;
    }

    @Override
    public int getOrdinal(Fabric fabric) {
        class_1661 inv = this.getInventoryPlayer(fabric);
        return inv.field_7545;
    }

    @Override
    public Class<? extends Inventory> getAdapterType() {
        return EquipmentSlotAdapter.class;
    }

    @Override
    public Slot getAdapter(Fabric fabric, Inventory parent) {
        return new HeldSlotAdapter(fabric, this, parent);
    }

    @Override
    public int slotCount() {
        return 1;
    }

    @Override
    public int getMaxStackSize(Fabric fabric) {
        return fabric.fabric$getMaxStackSize();
    }

    @Override
    public List<Lens> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<Lens> getSpanningChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<SlotLens> getSlots(Fabric fabric) {
        return Collections.singletonList(this.getSlotLens(fabric, 0));
    }

    @Override
    public Lens getLens(int index) {
        return this;
    }

    @Override
    public Map<Key<?>, Object> getDataFor(Lens lens) {
        return Collections.emptyMap();
    }

    @Override
    public boolean has(Lens lens) {
        return false;
    }

    @Override
    public boolean isSubsetOf(Collection<Lens> c) {
        return false;
    }

    @Override
    public SlotLens getSlotLens(Fabric fabric, int ordinal) {
        if (ordinal != 0) {
            throw new InvalidOrdinalException("Non-zero slot ordinal");
        }
        return this.hotbarLens.getSlotLens(fabric, this.getOrdinal(fabric));
    }

    public Predicate<EquipmentType> getEquipmentTypeFilter() {
        return e -> e == EquipmentTypes.MAINHAND.get();
    }

    public Predicate<ItemStackLike> getItemStackFilter() {
        return i -> true;
    }

    public Predicate<ItemType> getItemTypeFilter() {
        return i -> true;
    }

    @Override
    public String toString(int deep) {
        return "[HeldSlot]";
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public List<Lens> children() {
        return Collections.singletonList(this);
    }
}

