/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.query.type;

import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.EmptyInventoryImpl;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.comp.GridInventoryAdapter;
import org.spongepowered.common.inventory.lens.CompoundSlotLensProvider;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.query.SpongeQuery;
import org.spongepowered.math.vector.Vector2i;

public class GridQuery
extends SpongeQuery {
    private final Vector2i offset;
    private final Vector2i size;

    public GridQuery(Vector2i offset, Vector2i size) {
        this.offset = offset;
        this.size = size;
    }

    @Override
    public Inventory execute(Inventory inventory, InventoryAdapter adapter) {
        GridInventoryAdapter gridAdapter;
        if (adapter instanceof GridInventoryAdapter) {
            gridAdapter = (GridInventoryAdapter)adapter;
        } else {
            Lens lens = adapter.inventoryAdapter$getRootLens();
            if (lens instanceof GridInventoryLens) {
                GridInventoryLens gridInventoryLens = (GridInventoryLens)lens;
                gridAdapter = (GridInventoryAdapter)gridInventoryLens.getAdapter(adapter.inventoryAdapter$getFabric(), inventory);
            } else {
                return new EmptyInventoryImpl(inventory);
            }
        }
        Vector2i max = gridAdapter.dimensions();
        if (max.x() < this.offset.x() + this.size.x() && max.y() < this.offset.y() + this.size.y()) {
            return new EmptyInventoryImpl(inventory);
        }
        CompoundSlotLensProvider slotProvider = new CompoundSlotLensProvider();
        for (int dy = 0; dy < this.size.y(); ++dy) {
            for (int dx = 0; dx < this.size.x(); ++dx) {
                slotProvider.add(gridAdapter.getSlotLens(this.offset.x() + dx, this.offset.y() + dy));
            }
        }
        GridInventoryLens lens = new GridInventoryLens(0, this.size.x(), this.size.y(), slotProvider);
        return new GridInventoryAdapter(adapter.inventoryAdapter$getFabric(), lens, inventory);
    }
}

