/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1703;
import net.minecraft.class_1704;
import net.minecraft.class_1707;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8566;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.inventory.AbstractContainerMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.AbstractFurnaceMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.BeaconMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.BrewingStandMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.DispenserMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.HopperMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.HorseInventoryMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.ItemCombinerMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.MerchantMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.ResultSlotAccessor;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.inventory.SpongeBlockEntityCarrier;
import org.spongepowered.common.inventory.SpongeLocationCarrier;
import org.spongepowered.common.inventory.custom.CustomContainer;
import org.spongepowered.common.inventory.lens.CompoundSlotLensProvider;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.CompoundLens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.PrimaryPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.SingleGridLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;

public final class ContainerUtil {
    private static final Random RANDOM = new Random();

    private ContainerUtil() {
    }

    public static Container fromNative(class_1703 container) {
        return (Container)container;
    }

    public static class_1703 toNative(Container container) {
        return (class_1703)container;
    }

    public static void performBlockInventoryDrops(class_3218 worldServer, double x, double y, double z, class_1263 inventory) {
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        if (context.doesBlockEventTracking()) {
            for (int j = 0; j < inventory.method_5439(); ++j) {
                class_1799 itemStack = inventory.method_5438(j);
                if (itemStack.method_7960()) continue;
                float f = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
                while (!itemStack.method_7960()) {
                    int i = RANDOM.nextInt(21) + 10;
                    class_1542 entityitem = new class_1542((class_1937)worldServer, x + (double)f, y + (double)f1, z + (double)f2, itemStack.method_7971(i));
                    entityitem.method_18800(RANDOM.nextGaussian() * 0.05, RANDOM.nextGaussian() * 0.05 + 0.2, RANDOM.nextGaussian() * 0.05);
                    worldServer.method_8649((class_1297)entityitem);
                }
            }
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_1264.method_5449((class_1937)worldServer, (double)x, (double)y, (double)z, (class_1799)itemStack);
        }
    }

    public static Lens generateLens(class_1703 container, SlotLensProvider slots) {
        Map viewed = container.field_7761.stream().collect(Collectors.groupingBy(i -> Optional.ofNullable(i.field_7871), LinkedHashMap::new, Collectors.toList()));
        int index = 0;
        CraftingInventoryData crafting = new CraftingInventoryData();
        int chestHeight = 0;
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        for (Map.Entry entry : viewed.entrySet()) {
            List slotList = (List)entry.getValue();
            int slotCount = slotList.size();
            class_1263 subInventory = ((Optional)entry.getKey()).orElse(null);
            Lens lens = ContainerUtil.generateAdapterLens(slots, index, crafting, slotList, subInventory);
            if (lens.slotCount() != slotCount) {
                CompoundSlotLensProvider slotProvider = new CompoundSlotLensProvider().add(((InventoryBridge)subInventory).bridge$getAdapter());
                CompoundLens.Builder lensBuilder = CompoundLens.builder();
                for (class_1735 slot : slotList) {
                    lensBuilder.add(((InventoryBridge)slot).bridge$getAdapter().inventoryAdapter$getRootLens());
                }
                lens = lensBuilder.build(slotProvider);
            }
            lenses.add(lens);
            index += slotCount;
            if (chestHeight == -1) continue;
            if (lens instanceof DelegatingLens) {
                Lens delegated = ((DelegatingLens)lens).getDelegate();
                if (delegated instanceof PrimaryPlayerInventoryLens) {
                    delegated = ((PrimaryPlayerInventoryLens)delegated).getFullGrid();
                }
                if (delegated instanceof SingleGridLens) {
                    delegated = delegated.getSpanningChildren().get(0);
                }
                if (delegated instanceof GridInventoryLens) {
                    if (((GridInventoryLens)delegated).getWidth() == 9) {
                        chestHeight += ((GridInventoryLens)delegated).getHeight();
                        continue;
                    }
                    chestHeight = -1;
                    continue;
                }
                chestHeight = -1;
                continue;
            }
            chestHeight = -1;
        }
        ArrayList<Lens> additional = new ArrayList<Lens>();
        try {
            if (crafting.out != null && crafting.base != null && crafting.grid != null) {
                additional.add(new CraftingInventoryLens((int)crafting.out, (int)crafting.base, crafting.grid.method_17398(), crafting.grid.method_17397(), slots));
            } else if (crafting.base != null && crafting.grid != null) {
                additional.add(new GridInventoryLens(crafting.base, crafting.grid.method_17398(), crafting.grid.method_17397(), slots));
            }
        }
        catch (Exception e) {
            SpongeCommon.logger().error("Error while creating CraftingInventoryLensImpl or GridInventoryLensImpl for " + container.getClass().getName(), (Throwable)e);
        }
        if (chestHeight > 0) {
            additional.add(new GridInventoryLens(0, 9, chestHeight, slots));
        }
        return new ContainerLens(container.field_7761.size(), container.getClass(), slots, lenses, additional);
    }

    private static Lens generateAdapterLens(SlotLensProvider slots, int index, CraftingInventoryData crafting, List<class_1735> slotList, @Nullable class_1263 subInventory) {
        class_1735 slot;
        Lens lens = ((InventoryBridge)subInventory).bridge$getAdapter().inventoryAdapter$getRootLens();
        if (lens instanceof PlayerInventoryLens) {
            if (slotList.size() == 36) {
                return new DelegatingLens(index, new PrimaryPlayerInventoryLens(0, slots, true), slots);
            }
            return lens;
        }
        if (subInventory instanceof class_1731 && (slot = slotList.get(0)) instanceof ResultSlotAccessor) {
            crafting.out = index;
            if (crafting.base == null) {
                crafting.base = index + 1;
                crafting.grid = ((ResultSlotAccessor)slot).accessor$craftSlots();
            }
        }
        if (subInventory instanceof class_8566) {
            crafting.base = index;
            crafting.grid = (class_8566)subInventory;
        }
        return new DelegatingLens(index, slotList, lens, slots);
    }

    public static @Nullable Carrier getCarrier(Container container) {
        ServerLocation loc;
        Object player;
        if (container instanceof BlockCarrier) {
            return (BlockCarrier)container;
        }
        if (container instanceof CustomContainer) {
            return ((CustomContainer)container).inv.getCarrier();
        }
        if (container instanceof class_1707) {
            class_1263 inventory = ((class_1707)container).method_7629();
            if (inventory instanceof Carrier) {
                if (inventory instanceof class_2595) {
                    return (Carrier)inventory;
                }
                if (inventory instanceof class_1258) {
                    return (BlockCarrier)inventory;
                }
            }
            return ContainerUtil.carrierOrNull(inventory);
        }
        if (container instanceof HopperMenuAccessor) {
            return ContainerUtil.carrierOrNull(((HopperMenuAccessor)container).accessor$hopper());
        }
        if (container instanceof DispenserMenuAccessor) {
            return ContainerUtil.carrierOrNull(((DispenserMenuAccessor)container).accessor$dispenser());
        }
        if (container instanceof AbstractFurnaceMenuAccessor) {
            return ContainerUtil.carrierOrNull(((AbstractFurnaceMenuAccessor)container).accessor$container());
        }
        if (container instanceof BrewingStandMenuAccessor) {
            return ContainerUtil.carrierOrNull(((BrewingStandMenuAccessor)container).accessor$brewingStand());
        }
        if (container instanceof class_1704) {
            return new SpongeBlockEntityCarrier(((BeaconMenuAccessor)container).accessor$access().method_17395(class_1937::method_8321).orElse(null), container);
        }
        if (container instanceof HorseInventoryMenuAccessor) {
            return (Carrier)((HorseInventoryMenuAccessor)container).accessor$horse();
        }
        if (container instanceof MerchantMenuAccessor && ((MerchantMenuAccessor)container).accessor$trader() instanceof Carrier) {
            return (Carrier)((MerchantMenuAccessor)container).accessor$trader();
        }
        if (container instanceof ItemCombinerMenuAccessor && (player = ((ItemCombinerMenuAccessor)container).accessor$player()) instanceof class_3222) {
            return (Carrier)player;
        }
        if (container instanceof AbstractContainerMenuAccessor) {
            for (class_1735 slot : ((AbstractContainerMenuAccessor)container).accessor$slots()) {
                if (slot.field_7871 instanceof Carrier) {
                    return (Carrier)slot.field_7871;
                }
                if (!(slot.field_7871 instanceof class_2586)) continue;
                return new SpongeBlockEntityCarrier((class_2586)slot.field_7871, container);
            }
        }
        if ((loc = ((ContainerBridge)container).bridge$getOpenLocation()) != null) {
            return new SpongeLocationCarrier(loc, container);
        }
        return null;
    }

    private static Carrier carrierOrNull(class_1263 inventory) {
        if (inventory instanceof Carrier) {
            return (Carrier)inventory;
        }
        if (inventory instanceof CarriedInventory) {
            Optional carrier = ((CarriedInventory)inventory).carrier();
            return carrier.orElse(null);
        }
        return null;
    }

    private static class CraftingInventoryData {
        private @Nullable Integer out;
        private @Nullable Integer base;
        private @Nullable class_8566 grid;

        private CraftingInventoryData() {
        }
    }
}

