/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2281;
import net.minecraft.class_2595;
import net.minecraft.class_2609;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3924;
import net.minecraft.class_3971;
import net.minecraft.class_8566;
import net.minecraft.class_9694;
import net.minecraft.class_9696;
import net.minecraft.class_9697;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.carrier.chest.Chest;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.recipe.crafting.RecipeInput;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.inventory.AbstractCraftingMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.SmithingMenuAccessor;
import org.spongepowered.common.bridge.world.inventory.ViewableInventoryBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.entity.player.SpongeUserData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.custom.CarriedWrapperInventory;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static CraftingGridInventory toSpongeInventory(class_8566 inv) {
        return (CraftingGridInventory)inv;
    }

    public static RecipeInput.Crafting toSponge(class_9694 input) {
        return (RecipeInput.Crafting)input;
    }

    public static RecipeInput.Smithing toSponge(class_9697 input) {
        return (RecipeInput.Smithing)input;
    }

    public static RecipeInput.Single toSponge(class_9696 input) {
        return (RecipeInput.Single)input;
    }

    public static <I extends class_9694> Optional<I> toCraftingInput(Inventory inv) {
        Inventory inventory = inv;
        Objects.requireNonNull(inventory);
        Inventory inventory2 = inventory;
        int n = 0;
        class_9696 recipeInput = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2609.class, class_3924.class, AbstractCraftingMenuAccessor.class, class_1723.class, class_3971.class, SmithingMenuAccessor.class}, (Object)inventory2, n)) {
            case 0 -> {
                class_2609 furnace = (class_2609)inventory2;
                yield new class_9696(furnace.method_5438(0));
            }
            case 1 -> {
                class_3924 campfire = (class_3924)inventory2;
                yield campfire.method_17505().stream().filter(stack -> !stack.method_7960()).findFirst().map(class_9696::new).orElse(null);
            }
            case 2 -> {
                AbstractCraftingMenuAccessor menu = (AbstractCraftingMenuAccessor)inventory2;
                yield menu.accessor$craftSlots().method_59961();
            }
            case 3 -> {
                class_1723 menu = (class_1723)inventory2;
                yield menu.method_29281().method_59961();
            }
            case 4 -> {
                class_3971 menu = (class_3971)inventory2;
                yield new class_9696(menu.field_17629.method_5438(0));
            }
            case 5 -> {
                SmithingMenuAccessor menu = (SmithingMenuAccessor)inventory2;
                yield menu.invoker$createRecipeInput();
            }
            default -> null;
        };
        return Optional.ofNullable((class_9694)recipeInput);
    }

    public static <I extends class_9694> I toCraftingInputOrThrow(Inventory inv) {
        return (I)((class_9694)InventoryUtil.toCraftingInput(inv).orElseThrow(() -> new IllegalStateException("Invalid CraftingGridInventory. Could not find CraftingInventory.\nInventory was: " + inv.getClass().getSimpleName())));
    }

    public static Optional<Inventory> getDoubleChestInventory(class_2595 chest) {
        Optional connectedChestOptional = ((Chest)chest).connectedChest();
        if (!connectedChestOptional.isPresent()) {
            return Optional.empty();
        }
        class_2745 chestType = (class_2745)chest.method_11010().method_11654((class_2769)class_2281.field_10770);
        class_2595 connectedChest = (class_2595)connectedChestOptional.get();
        if (chestType == class_2745.field_12571) {
            return Optional.of((Inventory)new class_1258((class_1263)chest, (class_1263)connectedChest));
        }
        return Optional.of((Inventory)new class_1258((class_1263)connectedChest, (class_1263)chest));
    }

    public static Inventory toInventory(class_1263 inventory) {
        return InventoryUtil.toInventory(inventory, null);
    }

    public static Inventory toInventory(Object inventory, @Nullable Object forgeItemHandler) {
        if (forgeItemHandler == null) {
            if (inventory instanceof class_2595) {
                inventory = InventoryUtil.getDoubleChestInventory((class_2595)inventory).orElse((Inventory)inventory);
            }
            if (inventory instanceof Inventory) {
                return (Inventory)inventory;
            }
        }
        if (forgeItemHandler instanceof Inventory) {
            return (Inventory)forgeItemHandler;
        }
        return PlatformHooks.INSTANCE.getInventoryHooks().toInventory(inventory, forgeItemHandler);
    }

    public static InventoryAdapter findAdapter(Object inventory) {
        if (inventory instanceof InventoryAdapter) {
            return (InventoryAdapter)inventory;
        }
        if (inventory instanceof Fabric) {
            return new BasicInventoryAdapter((Fabric)inventory, null, null);
        }
        return PlatformHooks.INSTANCE.getInventoryHooks().findInventoryAdapter(inventory);
    }

    public static TrackedInventoryBridge forCapture(Object toCapture) {
        if (toCapture instanceof TrackedInventoryBridge) {
            return (TrackedInventoryBridge)toCapture;
        }
        return null;
    }

    public static PluginContainer getPluginContainer(Object inventory) {
        PluginContainer container;
        Object base;
        Optional carrier;
        if (inventory instanceof CustomInventory) {
            return ((CustomInventory)inventory).getPlugin();
        }
        if (inventory instanceof CarriedInventory && (carrier = ((CarriedInventory)inventory).carrier()).isPresent()) {
            inventory = carrier.get();
        }
        if ((base = inventory) instanceof BlockEntity) {
            ResourceKey key = Sponge.game().registry((RegistryType)RegistryTypes.BLOCK_ENTITY_TYPE).valueKey((Object)((BlockEntity)base).type());
            String pluginId = key.namespace();
            container = (PluginContainer)Sponge.pluginManager().plugin(pluginId).orElseThrow(() -> new AssertionError((Object)("Missing plugin " + pluginId + " for block " + key.namespace() + ":" + key.value())));
        } else if (base instanceof Entity) {
            ResourceKey key = (ResourceKey)class_1299.method_5890((class_1299)((class_1299)((Entity)base).type()));
            String pluginId = key.namespace();
            container = Sponge.pluginManager().plugin(pluginId).orElseGet(() -> {
                SpongeCommon.logger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.instance()).minecraftPlugin();
            });
        } else {
            container = base instanceof SpongeUserData ? ((Launch)Launch.instance()).minecraftPlugin() : Sponge.pluginManager().plugin(PlatformHooks.INSTANCE.getInventoryHooks().getModIdFromInventory(base.getClass())).orElseGet(() -> {
                SpongeCommon.logger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.instance()).minecraftPlugin();
            });
        }
        return container;
    }

    public static <T extends Carrier> CarriedInventory<T> carriedWrapperInventory(class_1263 inventory, T carrier) {
        return (CarriedInventory)new CarriedWrapperInventory(inventory, carrier);
    }

    public static void postContainerEvents(Set<class_1703> containers, TransactionalCaptureSupplier transactor) {
        for (class_1703 container : containers) {
            EffectTransactor ignore = transactor.logInventoryTransaction(container);
            try {
                container.method_7623();
            }
            finally {
                if (ignore == null) continue;
                ignore.close();
            }
        }
    }

    public static void updateInventoryNoEvents(Object inventory) {
        if (inventory instanceof ViewableInventoryBridge) {
            ViewableInventoryBridge bridge = (ViewableInventoryBridge)inventory;
            try (Object context = BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.getInstance());){
                ((PhaseContext)context).buildAndSwitch();
                for (class_3222 player : bridge.viewableBridge$getViewers()) {
                    player.field_7512.method_7623();
                }
            }
        }
    }
}

