/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_9283;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.util.Color;

public final class SpongeFireworkEffectBuilder
implements FireworkEffect.Builder {
    private boolean trail = false;
    private boolean flicker = false;
    private List<Color> colors = Lists.newArrayList();
    private List<Color> fades = Lists.newArrayList();
    private Supplier<FireworkShape> shape = FireworkShapes.SMALL_BALL;

    public SpongeFireworkEffectBuilder trail(boolean trail) {
        this.trail = trail;
        return this;
    }

    public SpongeFireworkEffectBuilder flicker(boolean flicker) {
        this.flicker = flicker;
        return this;
    }

    public SpongeFireworkEffectBuilder color(Color color) {
        Objects.requireNonNull(color);
        this.colors.add(color);
        return this;
    }

    public SpongeFireworkEffectBuilder colors(Color ... colors) {
        Objects.requireNonNull(colors);
        Collections.addAll(this.colors, colors);
        return this;
    }

    public SpongeFireworkEffectBuilder colors(Iterable<Color> colors) {
        Objects.requireNonNull(colors);
        for (Color color : colors) {
            this.colors.add(color);
        }
        return this;
    }

    public SpongeFireworkEffectBuilder fade(Color color) {
        Objects.requireNonNull(color);
        this.fades.add(color);
        return this;
    }

    public SpongeFireworkEffectBuilder fades(Color ... colors) {
        Objects.requireNonNull(colors);
        Collections.addAll(this.fades, colors);
        return this;
    }

    public SpongeFireworkEffectBuilder fades(Iterable<Color> colors) {
        Objects.requireNonNull(colors);
        for (Color color : colors) {
            this.fades.add(color);
        }
        return this;
    }

    public SpongeFireworkEffectBuilder shape(FireworkShape shape) {
        Objects.requireNonNull(shape);
        this.shape = () -> shape;
        return this;
    }

    public FireworkEffect build() {
        return (FireworkEffect)new class_9283((class_9283.class_1782)this.shape.get(), (IntList)new IntArrayList(this.colors.stream().map(Color::rgb).toList()), (IntList)new IntArrayList(this.fades.stream().map(Color::rgb).toList()), this.trail, this.flicker);
    }

    public FireworkEffect.Builder from(FireworkEffect value) {
        return this.trail(value.hasTrail()).colors((Iterable)value.colors()).fades((Iterable)value.fadeColors()).shape(value.shape()).flicker(value.flickers());
    }

    public SpongeFireworkEffectBuilder reset() {
        this.trail = false;
        this.flicker = false;
        this.colors = Lists.newArrayList();
        this.fades = Lists.newArrayList();
        this.shape = FireworkShapes.SMALL_BALL;
        return this;
    }
}

