/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9285;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.item.ItemStackDataComponentsUpdater;
import org.spongepowered.common.item.ItemStackSnapshotDuplicateManipulatorUpdater;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public final class SpongeItemStack {
    public static final ImmutableList<DataContentUpdater> STACK_UPDATERS = ImmutableList.of((Object)ItemStackSnapshotDuplicateManipulatorUpdater.INSTANCE, (Object)ItemStackDataComponentsUpdater.INSTANCE);

    @NotNull
    public static DataContainer getDataContainer(class_1799 mcStack) {
        class_2960 key = class_7923.field_41178.method_10221((Object)mcStack.method_7909());
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)((ItemStack)mcStack).contentVersion()).set(Constants.ItemStack.TYPE, (Object)key).set(Constants.ItemStack.COUNT, (Object)mcStack.method_7947());
        SpongeItemStack.cleanupOldCustomData(mcStack);
        class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)SpongeCommon.server().method_30611());
        DataResult componentsTag = class_9326.field_49589.encodeStart((DynamicOps)ops, (Object)mcStack.method_57380());
        DataContainer components = NBTTranslator.INSTANCE.translate((class_2487)componentsTag.getOrThrow());
        container.set(Constants.ItemStack.COMPONENTS, (Object)components);
        return container;
    }

    @NotNull
    public static class_9274 asEquipmentSlotGroup(EquipmentType equipmentType) {
        return switch ((class_1304)equipmentType) {
            default -> throw new MatchException(null, null);
            case class_1304.field_6173 -> class_9274.field_49217;
            case class_1304.field_6171 -> class_9274.field_49218;
            case class_1304.field_6166 -> class_9274.field_49220;
            case class_1304.field_6172 -> class_9274.field_49221;
            case class_1304.field_6174 -> class_9274.field_49222;
            case class_1304.field_6169 -> class_9274.field_49223;
            case class_1304.field_48824 -> class_9274.field_50127;
        };
    }

    private static void cleanupOldCustomData(class_1799 stack) {
        class_2487 unsafe = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
        unsafe.method_10551("SpongeData");
        Constants.NBT.filterSpongeCustomData(unsafe);
    }

    @NotNull
    public static Optional<ItemStack> createItemStack(DataView container) {
        Objects.requireNonNull(container);
        Integer version = container.getInt(Queries.CONTENT_VERSION).orElse(1);
        ImmutableList.Builder builder = ImmutableList.builder();
        int lastUpdaterVersion = version;
        for (DataContentUpdater updater : STACK_UPDATERS) {
            if (lastUpdaterVersion != updater.inputVersion()) continue;
            lastUpdaterVersion = updater.outputVersion();
            builder.add((Object)updater);
        }
        DataUpdaterDelegate delegate = new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)builder.build(), version, 3);
        DataView updatedContainer = delegate.update(container);
        if (!updatedContainer.contains(Constants.ItemStack.TYPE, new DataQuery[]{Constants.ItemStack.COUNT})) {
            return Optional.empty();
        }
        int count = (Integer)updatedContainer.getInt(Constants.ItemStack.COUNT).get();
        ItemType itemType = (ItemType)updatedContainer.getRegistryValue(Constants.ItemStack.TYPE, (RegistryType)RegistryTypes.ITEM_TYPE).orElseThrow(() -> new IllegalStateException("Unable to find item with id: "));
        class_1799 mcStack = new class_1799((class_1935)((class_1792)itemType), count);
        if (!mcStack.method_7960()) {
            mcStack.method_57366(SpongeItemStack.patchFromData(updatedContainer));
        }
        return Optional.of((ItemStack)mcStack);
    }

    public static class_9326 patchFromData(DataView container) {
        return container.getView(Constants.ItemStack.COMPONENTS).map(NBTTranslator.INSTANCE::translate).flatMap(compound -> {
            Dynamic dynamic = new Dynamic((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)SpongeCommon.server().method_30611()), compound);
            return class_9326.field_49589.decode(dynamic).result().map(Pair::getFirst);
        }).orElse(class_9326.field_49588);
    }

    public static final class FactoryImpl
    implements ItemStack.Factory {
        public ItemStack empty() {
            return (ItemStack)class_1799.field_8037;
        }
    }

    public static final class BuilderImpl
    extends AbstractDataBuilder<ItemStack>
    implements ItemStack.Builder {
        private ItemType type;
        private int quantity;
        private @Nullable LinkedHashMap<Key<?>, Object> keyValues;
        private class_9326 components = class_9326.field_49588;

        public BuilderImpl() {
            super(ItemStack.class, 1);
            this.reset();
        }

        public ItemStack.Builder itemType(ItemType itemType) {
            Objects.requireNonNull(itemType, "Item type cannot be null");
            this.type = itemType;
            return this;
        }

        public ItemType currentItem() {
            return this.type == null ? (ItemType)((BlockType)BlockTypes.AIR.get()).item().get() : this.type;
        }

        public ItemStack.Builder quantity(int quantity) throws IllegalArgumentException {
            Preconditions.checkArgument(quantity >= 0, "Quantity must not be smaller than 0");
            this.quantity = quantity;
            return this;
        }

        public <V> ItemStack.Builder add(Key<? extends Value<V>> key, V value) throws IllegalArgumentException {
            if (this.keyValues == null) {
                this.keyValues = new LinkedHashMap();
            }
            this.keyValues.put(Objects.requireNonNull(key, "Key cannot be null!"), Objects.requireNonNull(value, "Value cannot be null!"));
            return this;
        }

        public ItemStack.Builder fromItemStack(ItemStack itemStack) {
            Objects.requireNonNull(itemStack, "Item stack cannot be null");
            this.type = itemStack.type();
            this.quantity = itemStack.quantity();
            ItemStack itemStack2 = itemStack;
            if (itemStack2 instanceof class_1799) {
                class_1799 mcStack = (class_1799)itemStack2;
                this.components = mcStack.method_57380();
            }
            return this;
        }

        public ItemStack.Builder attributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
            Objects.requireNonNull(attributeType, "AttributeType cannot be null");
            Objects.requireNonNull(modifier, "AttributeModifier cannot be null");
            Objects.requireNonNull(equipmentType, "EquipmentType cannot be null");
            Optional<class_9285> existing = this.components.method_57845(class_9334.field_49636);
            if (existing == null) {
                existing = Optional.empty();
            }
            class_9285 modifiers = existing.map(class_9285.class::cast).orElse(class_9285.field_49326);
            class_6880 attribute = class_7923.field_41190.method_47983((Object)((class_1320)attributeType));
            class_9274 slotGroup = SpongeItemStack.asEquipmentSlotGroup(equipmentType);
            modifiers = modifiers.method_57484(attribute, (class_1322)modifier, slotGroup);
            class_9326.class_9327 builder = class_9326.method_57841();
            this.components.method_57846().forEach(entry -> builder.method_57854((class_9331)entry.getKey(), ((Optional)entry.getValue()).orElse(null)));
            builder.method_57854(class_9334.field_49636, (Object)modifiers);
            this.components = builder.method_57852();
            return this;
        }

        public ItemStack.Builder fromContainer(DataView container) {
            Optional<ItemStack> stack = SpongeItemStack.createItemStack(container);
            if (stack.isPresent()) {
                this.reset();
                return this.fromItemStack(stack.get());
            }
            SpongeCommon.logger().warn("Invalid ItemStack Container");
            return this;
        }

        public ItemStack.Builder fromSnapshot(ItemStackSnapshot snapshot) {
            Objects.requireNonNull(snapshot, "The snapshot was null!");
            this.itemType(snapshot.type());
            this.quantity(snapshot.quantity());
            for (Value.Immutable value : snapshot.getValues()) {
                this.add((Value)value);
            }
            if (snapshot instanceof SpongeItemStackSnapshot) {
                this.components = ((SpongeItemStackSnapshot)snapshot).getComponentsPatch();
            }
            return this;
        }

        public ItemStack.Builder fromBlockSnapshot(BlockSnapshot blockSnapshot) {
            Objects.requireNonNull(blockSnapshot, "The snapshot was null!");
            this.reset();
            BlockType blockType = blockSnapshot.state().type();
            class_2960 blockTypeKey = SpongeCommon.vanillaRegistry(class_7924.field_41254).method_10221((Object)((class_2248)blockType));
            Optional itemType = blockType.item();
            this.itemType((ItemType)itemType.orElseThrow(() -> new IllegalArgumentException("ItemType not found for block type: " + String.valueOf(blockTypeKey))));
            this.quantity(1);
            if (blockSnapshot instanceof SpongeBlockSnapshot) {
                ((SpongeBlockSnapshot)blockSnapshot).getCompound().ifPresent(compoundTag -> {
                    this.components = class_9326.method_57841().method_57854(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)compoundTag)).method_57852();
                });
            }
            return this;
        }

        public ItemStack.Builder fromBlockState(BlockState blockState) {
            Objects.requireNonNull(blockState, "blockState");
            BlockType blockType = blockState.type();
            class_2960 blockTypeKey = SpongeCommon.vanillaRegistry(class_7924.field_41254).method_10221((Object)((class_2248)blockType));
            this.itemType((ItemType)blockType.item().orElseThrow(() -> new IllegalArgumentException("Missing valid ItemType for BlockType: " + String.valueOf(blockTypeKey))));
            blockState.getValues().forEach(arg_0 -> ((BuilderImpl)this).add(arg_0));
            return this;
        }

        public ItemStack.Builder from(ItemStack value) {
            return this.fromItemStack(value);
        }

        protected Optional<ItemStack> buildContent(DataView container) throws InvalidDataException {
            return SpongeItemStack.createItemStack(container);
        }

        public ItemStack.Builder reset() {
            this.type = null;
            this.quantity = 1;
            this.components = class_9326.field_49588;
            return this;
        }

        public ItemStack build() throws IllegalStateException {
            Preconditions.checkState(this.type != null, "Item type has not been set");
            if (this.type == null || this.quantity <= 0) {
                return (ItemStack)class_1799.field_8037;
            }
            class_1799 mcStack = new class_1799((class_1935)((class_1792)this.type), this.quantity);
            mcStack.method_57366(this.components);
            ItemStack stack = (ItemStack)mcStack;
            if (this.keyValues != null) {
                this.keyValues.forEach((key, value) -> stack.offer(key, value));
            }
            return stack;
        }
    }
}

