/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.class_1799;
import net.minecraft.class_9326;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeItemStackSnapshot
implements ItemStackSnapshot {
    public static final ItemStackSnapshot EMPTY = new SpongeItemStackSnapshot(ItemStackUtil.fromNative(class_1799.field_8037));
    private final ItemType itemType;
    private final int quantity;
    private final int damageValue;
    private final ImmutableList<DataManipulator.Immutable> manipulators;
    private final transient ItemStack privateStack;
    private @MonotonicNonNull Set<Key<?>> keys;
    private @MonotonicNonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    Value.Immutable<?>> values;
    private final class_9326 components;
    private @Nullable UUID creatorUniqueId;

    public SpongeItemStackSnapshot(ItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        if (ItemStackUtil.toNative(itemStack) == class_1799.field_8037) {
            this.itemType = itemStack.type();
            this.quantity = 0;
            this.damageValue = 0;
            this.manipulators = ImmutableList.of();
            this.privateStack = itemStack;
            this.keys = ImmutableSet.of();
            this.values = ImmutableSet.of();
            this.components = class_9326.field_49588;
            return;
        }
        this.itemType = itemStack.type();
        this.quantity = itemStack.quantity();
        ImmutableList.Builder builder = ImmutableList.builder();
        DataManipulator.Mutable customData = ((SpongeDataHolderBridge)itemStack).bridge$getManipulator();
        builder.add((Object)customData.asImmutable());
        this.damageValue = ItemStackUtil.toNative(itemStack).method_7919();
        this.manipulators = builder.build();
        this.privateStack = itemStack.copy();
        this.components = ItemStackUtil.toNative(this.privateStack).method_57380();
    }

    public ItemType type() {
        return this.itemType == null ? (ItemType)class_1799.field_8037.method_7909() : this.itemType;
    }

    public int quantity() {
        return this.quantity;
    }

    public boolean isEmpty() {
        return this.privateStack.isEmpty();
    }

    public Collection<AttributeModifier> attributeModifiers(AttributeType attributeType, EquipmentType equipmentType) {
        return this.privateStack.attributeModifiers(attributeType, equipmentType);
    }

    public boolean isNone() {
        throw new UnsupportedOperationException("Implement is empty");
    }

    public int contentVersion() {
        return 3;
    }

    public DataContainer toContainer() {
        return SpongeItemStack.getDataContainer((class_1799)this.asMutable());
    }

    public <E> Optional<ItemStackSnapshot> transform(Key<? extends Value<E>> key, Function<E, E> function) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.transform(key, function);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.asImmutable());
    }

    public <E> Optional<ItemStackSnapshot> with(Key<? extends Value<E>> key, E value) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.offer(key, value);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.asImmutable());
    }

    public Optional<ItemStackSnapshot> with(Value<?> value) {
        return this.with(value.key(), value.get());
    }

    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.privateStack.get(key);
    }

    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.privateStack.getValue(key);
    }

    public boolean supports(Key<?> key) {
        return this.privateStack.supports(key);
    }

    public ItemStack asMutable() {
        class_1799 nativeStack = ItemStackUtil.cloneDefensiveNative(ItemStackUtil.toNative(this.privateStack.copy()));
        if (this.components != null) {
            nativeStack.method_57366(this.components);
        }
        for (DataManipulator.Immutable manipulator : this.manipulators) {
            ((ItemStack)nativeStack).copyFrom((ValueContainer)manipulator);
        }
        return ItemStackUtil.fromNative(nativeStack);
    }

    public ItemStack asMutableCopy() {
        return this.asMutable();
    }

    public ItemStackSnapshot asImmutable() {
        return this;
    }

    public ItemStackSnapshot copy() {
        return this;
    }

    public Set<Key<?>> getKeys() {
        if (this.keys == null) {
            this.keys = this.privateStack.getKeys();
        }
        return this.keys;
    }

    public Set<Value.Immutable<?>> getValues() {
        if (this.values == null) {
            this.values = this.privateStack.getValues();
        }
        return this.values;
    }

    public String toString() {
        ResourceKey resourceKey = Sponge.game().registry((RegistryType)RegistryTypes.ITEM_TYPE).valueKey((Object)this.itemType);
        return new StringJoiner(", ", SpongeItemStackSnapshot.class.getSimpleName() + "[", "]").add("itemType=" + String.valueOf(resourceKey)).add("quantity=" + this.quantity).toString();
    }

    public int getDamageValue() {
        return this.damageValue;
    }

    public class_9326 getComponentsPatch() {
        return this.components;
    }

    public Optional<UUID> getCreator() {
        return Optional.ofNullable(this.creatorUniqueId);
    }

    public void setCreator(@Nullable UUID uuid) {
        if (uuid != null) {
            this.creatorUniqueId = uuid;
        }
    }

    public ItemStackSnapshot withRawData(DataView container) throws InvalidDataException {
        ItemStack copy = this.privateStack.copy();
        copy.setRawData(container);
        return copy.asImmutable();
    }

    public Optional<ItemStackSnapshot> without(Key<?> key) {
        ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.remove(key);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.asImmutable());
    }

    public ItemStackSnapshot mergeWith(ItemStackSnapshot that, MergeFunction function) {
        ItemStack copy = this.privateStack.copy();
        copy.copyFrom((ValueContainer)that, function);
        return copy.asImmutable();
    }

    public boolean validateRawData(DataView container) {
        ItemStack copy = this.privateStack.copy();
        return copy.validateRawData(container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStackSnapshot that = (SpongeItemStackSnapshot)o;
        return this.quantity == that.quantity && this.damageValue == that.damageValue && Objects.equals(this.itemType, that.itemType) && Objects.equals(this.components, that.components) && Objects.equals(this.creatorUniqueId, that.creatorUniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.itemType, this.quantity, this.damageValue, this.components, this.creatorUniqueId);
    }

    public Component asComponent() {
        return this.privateStack.asComponent();
    }

    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(UnaryOperator<HoverEvent.ShowItem> op) {
        ResourceKey resourceKey = Sponge.game().registry((RegistryType)RegistryTypes.ITEM_TYPE).valueKey((Object)this.itemType);
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem((Keyed)resourceKey, (int)this.quantity(), SpongeAdventure.asAdventure(this.getComponentsPatch())))));
    }
}

