/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.enchantment;

import java.util.Objects;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;

public final class SpongeEnchantment
implements Enchantment {
    private final EnchantmentType enchantmentType;
    private final int level;

    public SpongeEnchantment(EnchantmentType enchantmentType, int level) {
        this.enchantmentType = enchantmentType;
        this.level = level;
    }

    public EnchantmentType type() {
        return this.enchantmentType;
    }

    public int level() {
        return this.level;
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.game().registry((RegistryType)RegistryTypes.ENCHANTMENT_TYPE).valueKey((Object)this.enchantmentType);
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Queries.ENCHANTMENT_ID, (Object)resourceKey).set(Queries.LEVEL, (Object)this.level);
    }

    public int hashCode() {
        return Objects.hash(this.enchantmentType, this.level);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SpongeEnchantment other = (SpongeEnchantment)object;
        return Objects.equals(this.enchantmentType, other.enchantmentType) && Objects.equals(this.level, other.level);
    }
}

