/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.enchantment;

import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.item.enchantment.SpongeEnchantment;
import org.spongepowered.common.util.Preconditions;

public final class SpongeEnchantmentBuilder
extends AbstractDataBuilder<Enchantment>
implements Enchantment.Builder {
    private @Nullable EnchantmentType enchantmentType;
    private @Nullable Integer level;

    public SpongeEnchantmentBuilder() {
        super(Enchantment.class, 1);
    }

    public Enchantment.Builder from(Enchantment value) {
        Objects.requireNonNull(value, "The enchantment to create a builder from cannot be null!");
        this.enchantmentType = value.type();
        this.level = value.level();
        return this;
    }

    public Enchantment.Builder reset() {
        this.enchantmentType = null;
        this.level = null;
        return this;
    }

    public Enchantment.Builder type(EnchantmentType enchantmentType) {
        this.enchantmentType = Objects.requireNonNull(enchantmentType, "Enchantment type cannot be null!");
        return this;
    }

    public Enchantment.Builder level(int level) {
        Preconditions.checkArgument(level >= Short.MIN_VALUE, String.format("The specified level must be greater than %s (was %s)!", (short)Short.MIN_VALUE, level));
        Preconditions.checkArgument(level <= Short.MAX_VALUE, String.format("The specified level must not be greater than %s (was %s)!", (short)Short.MAX_VALUE, level));
        this.level = level;
        return this;
    }

    public Enchantment build() {
        Preconditions.checkState(this.enchantmentType != null, "The enchantment type must be set!");
        Preconditions.checkState(this.level != null, "The level of the enchantment must be set!");
        return new SpongeEnchantment(this.enchantmentType, this.level);
    }

    protected Optional<Enchantment> buildContent(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container, "The data view cannot be null!");
        if (!container.contains(Queries.ENCHANTMENT_ID, new DataQuery[]{Queries.LEVEL})) {
            return Optional.empty();
        }
        Optional enchantmentType = container.getRegistryValue(Queries.ENCHANTMENT_ID, (RegistryType)RegistryTypes.ENCHANTMENT_TYPE);
        Optional level = container.getInt(Queries.LEVEL);
        Enchantment.Builder builder = Enchantment.builder();
        level.map(arg_0 -> ((Enchantment.Builder)builder).level(arg_0));
        return enchantmentType.map(arg_0 -> ((Enchantment.Builder)builder).type(arg_0)).map(Enchantment.Builder::build);
    }
}

