/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.enchantment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class SpongeRandomEnchantmentListBuilder
implements Enchantment.RandomListBuilder {
    private @Nullable Integer seed;
    private @Nullable Integer option;
    private @Nullable Integer level;
    private @Nullable List<Enchantment> pool;
    private @Nullable ItemStack item;
    private final class_5819 randomSource = class_5819.method_43047();

    public Enchantment.RandomListBuilder seed(int seed) {
        this.seed = seed;
        return this;
    }

    public Enchantment.RandomListBuilder option(int option) {
        this.option = option;
        return this;
    }

    public Enchantment.RandomListBuilder level(int level) {
        this.level = level;
        return this;
    }

    public Enchantment.RandomListBuilder fixedPool(List<Enchantment> pool) {
        this.pool = pool;
        return this;
    }

    public Enchantment.RandomListBuilder item(ItemStack item) {
        this.item = item;
        return this;
    }

    public List<Enchantment> build() throws IllegalStateException {
        List enchantments;
        Objects.requireNonNull(this.seed, "The random seed cannot be null");
        Objects.requireNonNull(this.option, "The option cannot be null");
        Objects.requireNonNull(this.level, "The level cannot be null");
        if (this.pool == null || this.pool.isEmpty()) {
            Objects.requireNonNull(this.item, "The item cannot be null");
            this.randomSource.method_43052((long)(this.seed + this.option));
            class_2378 registry = SpongeCommon.server().method_30611().method_30530(class_7924.field_41265);
            Stream<class_6880> stream = registry.method_42017().map($$0x -> $$0x);
            enchantments = class_1890.method_8230((class_5819)this.randomSource, (class_1799)ItemStackUtil.toNative(this.item), (int)this.level, stream);
        } else {
            this.randomSource.method_43052((long)(this.seed + this.option));
            enchantments = this.basedOfFixedPool(this.randomSource, this.pool);
        }
        return SpongeRandomEnchantmentListBuilder.fromNative(enchantments);
    }

    private List<class_1889> basedOfFixedPool(class_5819 randomIn, List<Enchantment> pool) {
        ArrayList list = Lists.newArrayList();
        List<class_1889> list1 = SpongeRandomEnchantmentListBuilder.toNative(pool);
        if (!list1.isEmpty()) {
            class_6011.method_34986((class_5819)randomIn, list1).ifPresent(list::add);
            while (randomIn.method_43048(50) <= this.level) {
                class_1890.method_8231(list1, (class_1889)((class_1889)class_156.method_20793((List)list)));
                if (list1.isEmpty()) break;
                class_6011.method_34986((class_5819)randomIn, list1).ifPresent(list::add);
                this.level = this.level / 2;
            }
        }
        return list;
    }

    public static List<Enchantment> fromNative(List<class_1889> list) {
        return list.stream().map(data -> Enchantment.of((EnchantmentType)((EnchantmentType)data.field_9093.comp_349()), (int)data.field_9094)).collect(Collectors.toList());
    }

    public static List<class_1889> toNative(List<Enchantment> list) {
        class_2378 registry = SpongeCommon.server().method_30611().method_30530(class_7924.field_41265);
        return list.stream().map(ench -> {
            class_6880 mcEnch = registry.method_47983((Object)((class_1887)ench.type()));
            return new class_1889(mcEnch, ench.level());
        }).collect(Collectors.toList());
    }

    public Enchantment.RandomListBuilder reset() {
        this.pool = null;
        this.level = null;
        this.option = null;
        this.seed = null;
        this.item = null;
        return this;
    }
}

